/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.generation;

import com.cmdpro.datanessence.api.block.Machine;
import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.EssenceType;
import com.cmdpro.datanessence.api.essence.container.MultiEssenceContainer;
import com.cmdpro.datanessence.api.item.EssenceShard;
import com.cmdpro.datanessence.api.util.BufferUtil;
import com.cmdpro.datanessence.block.generation.EssenceBurner;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.screen.EssenceBurnerMenu;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EssenceBurnerBlockEntity
extends BlockEntity
implements MenuProvider,
EssenceBlockEntity,
Machine {
    public MultiEssenceContainer storage = new MultiEssenceContainer(List.of(EssenceTypeRegistry.ESSENCE.get(), EssenceTypeRegistry.LUNAR_ESSENCE.get(), EssenceTypeRegistry.NATURAL_ESSENCE.get(), EssenceTypeRegistry.EXOTIC_ESSENCE.get()), 1000.0f);
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            EssenceBurnerBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return stack.getItem() instanceof EssenceShard;
            }
            if (slot == 1) {
                return stack.getBurnTime(RecipeType.SMELTING) > 0;
            }
            return super.isItemValid(slot, stack);
        }
    };
    public float burnTime;
    public float maxBurnTime = 1.0f;
    public float essenceBurnCooldown;
    private final CombinedInvWrapper combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler});
    public boolean lit;

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public void drops() {
        SimpleContainer inventory = this.getInv();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public EssenceBurnerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.ESSENCE_BURNER.get(), pos, state);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public CombinedInvWrapper getCombinedInvWrapper() {
        return this.combinedInvWrapper;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        this.storage.fromNbt(tag.getCompound("EssenceStorage"));
        this.maxBurnTime = tag.getFloat("maxBurnTime");
        this.burnTime = tag.getFloat("burnTime");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putFloat("maxBurnTime", this.maxBurnTime);
        tag.putFloat("burnTime", this.burnTime);
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putFloat("maxBurnTime", this.maxBurnTime);
        tag.putFloat("burnTime", this.burnTime);
        tag.putFloat("essenceBurnCooldown", this.essenceBurnCooldown);
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("inventory"));
        this.storage.fromNbt(nbt.getCompound("EssenceStorage"));
        this.maxBurnTime = nbt.getFloat("maxBurnTime");
        this.burnTime = nbt.getFloat("burnTime");
        this.essenceBurnCooldown = nbt.getFloat("essenceBurnCooldown");
    }

    public SimpleContainer getInv() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public static void tick(Level world, BlockPos pos, BlockState pState, EssenceBurnerBlockEntity burner) {
        if (!world.isClientSide()) {
            BufferUtil.getItemsFromBuffersBelow(burner, (IItemHandler)burner.itemHandler);
            burner.lit = false;
            Item item = burner.itemHandler.getStackInSlot(0).getItem();
            if (item instanceof EssenceShard) {
                EssenceShard shard = (EssenceShard)item;
                boolean hasSpaceToGenerate = true;
                for (Map.Entry<Supplier<EssenceType>, Float> i : shard.essence.entrySet()) {
                    if (!(burner.storage.getEssence(i.getKey().get()) + i.getValue().floatValue() > burner.storage.getMaxEssence())) continue;
                    hasSpaceToGenerate = false;
                    break;
                }
                if (burner.burnTime <= 0.0f) {
                    ItemStack fuel;
                    burner.essenceBurnCooldown = 0.0f;
                    if (hasSpaceToGenerate && (fuel = burner.itemHandler.getStackInSlot(1)).getBurnTime(RecipeType.SMELTING) > 0) {
                        burner.maxBurnTime = fuel.getBurnTime(RecipeType.SMELTING);
                        burner.itemHandler.extractItem(1, 1, false);
                        if (fuel.hasCraftingRemainingItem()) {
                            ItemStack remainder = fuel.getCraftingRemainingItem();
                            world.addFreshEntity((Entity)new ItemEntity(world, pos.getCenter().x, pos.getCenter().y + 0.6, pos.getCenter().z, remainder));
                        }
                        burner.burnTime = burner.maxBurnTime;
                        burner.lit = true;
                    }
                } else {
                    burner.lit = true;
                    burner.essenceBurnCooldown -= 1.0f;
                    burner.burnTime -= 1.0f;
                    if (burner.essenceBurnCooldown <= 0.0f && hasSpaceToGenerate) {
                        burner.itemHandler.extractItem(0, 1, false);
                        for (Map.Entry<Supplier<EssenceType>, Float> i : shard.essence.entrySet()) {
                            burner.storage.addEssence(i.getKey().get(), i.getValue().floatValue());
                        }
                        burner.essenceBurnCooldown = 50.0f;
                    }
                }
            }
            if (burner.lit != (Boolean)pState.getValue((Property)EssenceBurner.LIT)) {
                BlockState state = (BlockState)pState.setValue((Property)EssenceBurner.LIT, (Comparable)Boolean.valueOf(burner.lit));
                burner.level.setBlock(pos, state, 3);
            }
            burner.updateBlock();
        }
    }

    protected void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new EssenceBurnerMenu(pContainerId, pInventory, this);
    }

    @Override
    public List<Direction> getValidInputDirections() {
        return List.of(Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
    }
}

