/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.processing;

import com.cmdpro.datanessence.api.block.Machine;
import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.container.SingleEssenceContainer;
import com.cmdpro.datanessence.api.util.BufferUtil;
import com.cmdpro.datanessence.recipe.DryingRecipe;
import com.cmdpro.datanessence.recipe.RecipeInputWithFluid;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import com.cmdpro.datanessence.screen.DryingTableMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DryingTableBlockEntity
extends BlockEntity
implements MenuProvider,
EssenceBlockEntity,
Machine {
    public SingleEssenceContainer storage = new SingleEssenceContainer(EssenceTypeRegistry.ESSENCE.get(), 1000.0f);
    public int workTime;
    public int maxWorkTime;
    public DryingRecipe recipe;
    private final FluidTank fluidHandler = new FluidTank(1000){

        protected void onContentsChanged() {
            DryingTableBlockEntity.this.setChanged();
            DryingTableBlockEntity.this.checkRecipe();
            DryingTableBlockEntity.this.updateBlock();
        }
    };
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            DryingTableBlockEntity.this.setChanged();
            DryingTableBlockEntity.this.checkRecipe();
            DryingTableBlockEntity.this.updateBlock();
        }
    };
    private final ItemStackHandler outputItemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            DryingTableBlockEntity.this.setChanged();
        }
    };
    private final CombinedInvWrapper combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler, this.outputItemHandler});

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public IItemHandler getOutputHandler() {
        return this.outputItemHandler;
    }

    public CombinedInvWrapper getCombinedInvWrapper() {
        return this.combinedInvWrapper;
    }

    public DryingTableBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntityRegistry.DRYING_TABLE.get(), pos, blockState);
    }

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new DryingTableMenu(containerId, playerInventory, this);
    }

    public SimpleContainer getInv() {
        int i;
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots() + this.outputItemHandler.getSlots());
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        for (i = 0; i < this.outputItemHandler.getSlots(); ++i) {
            inventory.setItem(i + this.itemHandler.getSlots(), this.outputItemHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public RecipeInputWithFluid getCraftingInv() {
        SingleRecipeInput inventory = new SingleRecipeInput(this.itemHandler.getStackInSlot(0));
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        for (int i = 0; i < this.fluidHandler.getTanks(); ++i) {
            fluids.add(this.fluidHandler.getFluidInTank(i));
        }
        return new RecipeInputWithFluid((RecipeInput)inventory, fluids);
    }

    public void drops() {
        SimpleContainer inventory = this.getInv();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void checkRecipe() {
        Optional recipe = this.level.getRecipeManager().getRecipeFor(RecipeRegistry.DRYING_TYPE.get(), (RecipeInput)this.getCraftingInv(), this.level);
        if (recipe.isPresent()) {
            this.recipe = (DryingRecipe)((RecipeHolder)recipe.get()).value();
        }
        if (recipe.isEmpty()) {
            this.recipe = null;
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide) {
            this.checkRecipe();
        }
    }

    public static void tick(Level world, BlockPos pos, BlockState state, DryingTableBlockEntity dryingTable) {
        if (!world.isClientSide()) {
            BufferUtil.getEssenceFromBuffersBelow((BlockEntity)dryingTable, EssenceTypeRegistry.ESSENCE.get());
            BufferUtil.getFluidsFromBuffersBelow(dryingTable, (IFluidHandler)dryingTable.fluidHandler);
            BufferUtil.getItemsFromBuffersBelow(dryingTable, (IItemHandler)dryingTable.itemHandler);
            if (dryingTable.getStorage().getEssence(EssenceTypeRegistry.ESSENCE.get()) >= 0.5f && dryingTable.recipe != null) {
                ItemStack assembled = dryingTable.recipe.assemble(dryingTable.getCraftingInv(), (HolderLookup.Provider)world.registryAccess());
                if (dryingTable.outputItemHandler.insertItem(0, assembled, true).isEmpty()) {
                    ++dryingTable.workTime;
                    dryingTable.getStorage().removeEssence(EssenceTypeRegistry.ESSENCE.get(), 0.5f);
                    if (dryingTable.workTime >= dryingTable.recipe.getTime()) {
                        dryingTable.fluidHandler.drain(dryingTable.recipe.getInput(), IFluidHandler.FluidAction.EXECUTE);
                        dryingTable.outputItemHandler.insertItem(0, assembled, false);
                        dryingTable.itemHandler.extractItem(0, 1, false);
                        dryingTable.workTime = 0;
                    }
                    dryingTable.updateBlock();
                }
            } else {
                dryingTable.workTime = -1;
            }
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.put("fluids", (Tag)this.fluidHandler.writeToNBT(pRegistries, new CompoundTag()));
        tag.put("output", (Tag)this.outputItemHandler.serializeNBT(pRegistries));
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("workTime", this.workTime);
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("inventory"));
        this.fluidHandler.readFromNBT(pRegistries, nbt.getCompound("fluids"));
        this.outputItemHandler.deserializeNBT(pRegistries, nbt.getCompound("output"));
        this.storage.fromNbt(nbt.getCompound("EssenceStorage"));
        this.workTime = nbt.getInt("workTime");
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        this.storage.fromNbt(tag.getCompound("EssenceStorage"));
        this.workTime = tag.getInt("workTime");
        this.itemHandler.deserializeNBT(pRegistries, tag.getCompound("itemHandler"));
        this.fluidHandler.readFromNBT(pRegistries, tag.getCompound("fluidHandler"));
        this.outputItemHandler.deserializeNBT(pRegistries, tag.getCompound("outputItemHandler"));
        this.maxWorkTime = tag.getInt("maxWorkTime");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("workTime", this.workTime);
        tag.put("itemHandler", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.put("fluidHandler", (Tag)this.fluidHandler.writeToNBT(pRegistries, new CompoundTag()));
        tag.put("outputItemHandler", (Tag)this.outputItemHandler.serializeNBT(pRegistries));
        tag.putInt("maxWorkTime", this.recipe != null ? this.recipe.getTime() : -1);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    @Override
    public List<Direction> getValidInputDirections() {
        return List.of(Direction.DOWN, Direction.UP);
    }
}

