/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.processing;

import com.cmdpro.datanessence.api.block.Machine;
import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.container.SingleEssenceContainer;
import com.cmdpro.datanessence.api.util.BufferUtil;
import com.cmdpro.datanessence.block.processing.EssenceFurnace;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.screen.EssenceFurnaceMenu;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EssenceFurnaceBlockEntity
extends BlockEntity
implements MenuProvider,
EssenceBlockEntity,
Machine {
    public SingleEssenceContainer storage = new SingleEssenceContainer(EssenceTypeRegistry.ESSENCE.get(), 1000.0f);
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            EssenceFurnaceBlockEntity.this.setChanged();
            EssenceFurnaceBlockEntity.this.checkRecipes();
        }
    };
    private final ItemStackHandler outputItemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            EssenceFurnaceBlockEntity.this.setChanged();
        }
    };
    private final CombinedInvWrapper combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler, this.outputItemHandler});
    public ItemStack item = ItemStack.EMPTY;
    public int workTime;
    public double recipeTime;
    public SmeltingRecipe recipe;
    public float essenceCost;
    public boolean lit;

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public void drops() {
        SimpleContainer inventory = this.getInv();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public IItemHandler getOutputHandler() {
        return this.outputItemHandler;
    }

    public CombinedInvWrapper getCombinedInvWrapper() {
        return this.combinedInvWrapper;
    }

    public EssenceFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.ESSENCE_FURNACE.get(), pos, state);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        this.storage.fromNbt(tag.getCompound("EssenceStorage"));
        this.workTime = tag.getInt("workTime");
        this.recipeTime = tag.getDouble("recipeTime");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("workTime", this.workTime);
        tag.putDouble("recipeTime", this.recipeTime);
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("input", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.put("output", (Tag)this.outputItemHandler.serializeNBT(pRegistries));
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("workTime", this.workTime);
        tag.putDouble("recipeTime", this.recipeTime);
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("input"));
        this.outputItemHandler.deserializeNBT(pRegistries, nbt.getCompound("output"));
        this.storage.fromNbt(nbt.getCompound("EssenceStorage"));
        this.workTime = nbt.getInt("workTime");
        this.recipeTime = nbt.getDouble("recipeTime");
    }

    public SimpleContainer getInv() {
        int i;
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots() + this.outputItemHandler.getSlots());
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        for (i = 0; i < this.outputItemHandler.getSlots(); ++i) {
            inventory.setItem(i + this.itemHandler.getSlots(), this.outputItemHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public SingleRecipeInput getCraftingInv() {
        SingleRecipeInput inventory = new SingleRecipeInput(this.itemHandler.getStackInSlot(0));
        return inventory;
    }

    public void checkRecipes() {
        Optional recipe = this.level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)this.getCraftingInv(), this.level);
        if (recipe.isPresent()) {
            if (!((SmeltingRecipe)((RecipeHolder)recipe.get()).value()).equals(this.recipe)) {
                this.workTime = 0;
            }
            this.recipe = (SmeltingRecipe)((RecipeHolder)recipe.get()).value();
            this.recipeTime = (double)((SmeltingRecipe)((RecipeHolder)recipe.get()).value()).getCookingTime() * 0.75;
        } else {
            this.recipe = null;
        }
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, EssenceFurnaceBlockEntity pBlockEntity) {
        if (!pLevel.isClientSide()) {
            BufferUtil.getEssenceFromBuffersBelow((BlockEntity)pBlockEntity, EssenceTypeRegistry.ESSENCE.get());
            BufferUtil.getItemsFromBuffersBelow(pBlockEntity, (IItemHandler)pBlockEntity.itemHandler);
            boolean resetWorkTime = true;
            pBlockEntity.lit = false;
            if (pBlockEntity.getStorage().getEssence(EssenceTypeRegistry.ESSENCE.get()) >= 1.0f) {
                ItemStack result;
                if (pBlockEntity.recipe != null && pBlockEntity.outputItemHandler.insertItem(0, result = pBlockEntity.recipe.getResultItem((HolderLookup.Provider)pLevel.registryAccess()), true).isEmpty()) {
                    resetWorkTime = false;
                    pBlockEntity.lit = true;
                    ++pBlockEntity.workTime;
                    pBlockEntity.getStorage().removeEssence(EssenceTypeRegistry.ESSENCE.get(), 1.0f);
                    if ((double)pBlockEntity.workTime >= pBlockEntity.recipeTime) {
                        pBlockEntity.outputItemHandler.insertItem(0, pBlockEntity.recipe.assemble(pBlockEntity.getCraftingInv(), (HolderLookup.Provider)pLevel.registryAccess()), false);
                        pBlockEntity.itemHandler.extractItem(0, 1, false);
                        pBlockEntity.workTime = 0;
                    }
                }
            } else {
                pBlockEntity.recipe = null;
            }
            if (resetWorkTime) {
                pBlockEntity.workTime = -1;
            }
            if (pBlockEntity.lit != (Boolean)pState.getValue((Property)EssenceFurnace.LIT)) {
                BlockState state = (BlockState)pState.setValue((Property)EssenceFurnace.LIT, (Comparable)Boolean.valueOf(pBlockEntity.lit));
                pBlockEntity.level.setBlock(pPos, state, 3);
            }
            pBlockEntity.updateBlock();
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide) {
            this.checkRecipes();
        }
    }

    protected void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new EssenceFurnaceMenu(pContainerId, pInventory, this);
    }

    private static boolean hasNotReachedStackLimit(EssenceFurnaceBlockEntity entity, ItemStack toAdd) {
        if (toAdd.is(entity.outputItemHandler.getStackInSlot(0).getItem())) {
            return entity.outputItemHandler.getStackInSlot(0).getCount() + toAdd.getCount() <= entity.outputItemHandler.getStackInSlot(0).getMaxStackSize();
        }
        return entity.outputItemHandler.getStackInSlot(0).isEmpty();
    }

    @Override
    public List<Direction> getValidInputDirections() {
        return List.of(Direction.DOWN, Direction.UP);
    }
}

