/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.processing;

import com.cmdpro.databank.model.animation.DatabankAnimationReference;
import com.cmdpro.databank.model.animation.DatabankAnimationState;
import com.cmdpro.datanessence.api.block.BaseFabricatorBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceType;
import com.cmdpro.datanessence.client.FactorySong;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import com.cmdpro.datanessence.screen.FabricatorMenu;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FabricatorBlockEntity
extends BaseFabricatorBlockEntity
implements MenuProvider {
    public DatabankAnimationState animState = new DatabankAnimationState("idle").addAnim(new DatabankAnimationReference("idle", (state, anim) -> {}, (state, anim) -> {})).addAnim(new DatabankAnimationReference("ready", (state, anim) -> {}, (state, anim) -> {}));

    public void setLevel(Level level) {
        super.setLevel(level);
        this.animState.setLevel(level);
    }

    public FabricatorBlockEntity(BlockPos pos, BlockState state2) {
        super(BlockEntityRegistry.FABRICATOR.get(), pos, state2);
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new FabricatorMenu(pContainerId, pInventory, this);
    }

    @Override
    public List<EssenceType> getSupportedEssenceTypes() {
        return List.of(EssenceTypeRegistry.ESSENCE.get());
    }

    @Override
    public float getMaxEssence() {
        return 1000.0f;
    }

    @Override
    public void tick(Level world, BlockPos pos, BlockState state, BaseFabricatorBlockEntity fabricator) {
        super.tick(world, pos, state, fabricator);
        if (world.isClientSide() && fabricator.time >= 0 && fabricator.essenceCost != null) {
            ClientHandler.markFactorySong(pos);
        }
    }

    private static class ClientHandler {
        static FactorySong.FactoryLoop industrialSound = FactorySong.getLoop((SoundEvent)SoundRegistry.FABRICATOR_LOOP.value());

        private ClientHandler() {
        }

        public static void markFactorySong(BlockPos pos) {
            industrialSound.addSource(pos);
        }
    }
}

