/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.processing;

import com.cmdpro.databank.model.animation.DatabankAnimationReference;
import com.cmdpro.databank.model.animation.DatabankAnimationState;
import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.block.Machine;
import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.EssenceType;
import com.cmdpro.datanessence.api.essence.container.MultiEssenceContainer;
import com.cmdpro.datanessence.api.util.BufferUtil;
import com.cmdpro.datanessence.client.particle.CircleParticleOptions;
import com.cmdpro.datanessence.client.particle.ConfigurableParticleOptions;
import com.cmdpro.datanessence.data.datatablet.Entry;
import com.cmdpro.datanessence.item.DataDrive;
import com.cmdpro.datanessence.recipe.InfusionRecipe;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.DataComponentRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import com.cmdpro.datanessence.screen.InfuserMenu;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfuserBlockEntity
extends BlockEntity
implements MenuProvider,
EssenceBlockEntity,
Machine {
    public DatabankAnimationState animState = new DatabankAnimationState("idle").addAnim(new DatabankAnimationReference("idle", (state, anim) -> {}, (state, anim) -> {})).addAnim(new DatabankAnimationReference("active", (state, anim) -> {}, (state, anim) -> {})).addAnim(new DatabankAnimationReference("deactivated", (state, anim) -> {}, (state, anim) -> {}));
    public MultiEssenceContainer storage = new MultiEssenceContainer(List.of(EssenceTypeRegistry.ESSENCE.get(), EssenceTypeRegistry.LUNAR_ESSENCE.get(), EssenceTypeRegistry.NATURAL_ESSENCE.get(), EssenceTypeRegistry.EXOTIC_ESSENCE.get()), 1000.0f);
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            InfuserBlockEntity.this.setChanged();
            InfuserBlockEntity.this.checkRecipes();
        }
    };
    private final ItemStackHandler dataDriveHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            InfuserBlockEntity.this.setChanged();
            InfuserBlockEntity.this.checkRecipes();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return stack.getItem() instanceof DataDrive;
            }
            return super.isItemValid(slot, stack);
        }
    };
    private final ItemStackHandler outputItemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            InfuserBlockEntity.this.setChanged();
        }
    };
    private final CombinedInvWrapper combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler, this.dataDriveHandler, this.outputItemHandler});
    public ItemStack item = ItemStack.EMPTY;
    public int workTime;
    public InfusionRecipe recipe;
    public boolean enoughEssence;
    public Map<ResourceLocation, Float> essenceCost;

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        this.animState.setLevel(level);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide) {
            this.checkRecipes();
        }
    }

    public void drops() {
        SimpleContainer inventory = this.getInv();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public IItemHandler getDataDriveHandler() {
        return this.dataDriveHandler;
    }

    public IItemHandler getOutputHandler() {
        return this.outputItemHandler;
    }

    public CombinedInvWrapper getCombinedInvWrapper() {
        return this.combinedInvWrapper;
    }

    public InfuserBlockEntity(BlockPos pos, BlockState state2) {
        super(BlockEntityRegistry.INFUSER.get(), pos, state2);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        this.storage.fromNbt(tag.getCompound("EssenceStorage"));
        this.workTime = tag.getInt("workTime");
        this.item = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)tag.getCompound("item"));
        if (tag.contains("essenceCost")) {
            CompoundTag cost = tag.getCompound("essenceCost");
            this.essenceCost = new HashMap<ResourceLocation, Float>();
            for (String i : cost.getAllKeys()) {
                ResourceLocation location = ResourceLocation.tryParse((String)i);
                this.essenceCost.put(location, Float.valueOf(cost.getFloat(i)));
            }
        } else {
            this.essenceCost = null;
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("workTime", this.workTime);
        tag.put("item", this.item.saveOptional(pRegistries));
        if (this.essenceCost != null) {
            CompoundTag cost = new CompoundTag();
            for (Map.Entry<ResourceLocation, Float> i : this.essenceCost.entrySet()) {
                cost.putFloat(i.getKey().toString(), i.getValue().floatValue());
            }
            tag.put("essenceCost", (Tag)cost);
        }
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("input", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.put("dataDrive", (Tag)this.dataDriveHandler.serializeNBT(pRegistries));
        tag.put("output", (Tag)this.outputItemHandler.serializeNBT(pRegistries));
        tag.putInt("workTime", this.workTime);
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("input"));
        this.dataDriveHandler.deserializeNBT(pRegistries, nbt.getCompound("dataDrive"));
        this.outputItemHandler.deserializeNBT(pRegistries, nbt.getCompound("output"));
        this.storage.fromNbt(nbt.getCompound("EssenceStorage"));
        this.workTime = nbt.getInt("workTime");
    }

    public SimpleContainer getInv() {
        int i;
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots() + this.outputItemHandler.getSlots() + this.dataDriveHandler.getSlots());
        for (i = 0; i < this.dataDriveHandler.getSlots(); ++i) {
            inventory.setItem(i, this.dataDriveHandler.getStackInSlot(i));
        }
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i + this.dataDriveHandler.getSlots(), this.itemHandler.getStackInSlot(i));
        }
        for (i = 0; i < this.outputItemHandler.getSlots(); ++i) {
            inventory.setItem(i + this.dataDriveHandler.getSlots() + this.itemHandler.getSlots(), this.outputItemHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public RecipeInput getCraftingInv() {
        SingleRecipeInput inventory = new SingleRecipeInput(this.itemHandler.getStackInSlot(0));
        return inventory;
    }

    public void checkRecipes() {
        Optional<RecipeHolder> recipe = this.level.getRecipeManager().getRecipesFor(RecipeRegistry.INFUSION_TYPE.get(), this.getCraftingInv(), this.level).stream().filter(a -> ((InfusionRecipe)a.value()).getEntry().equals((Object)DataDrive.getEntryId(this.dataDriveHandler.getStackInSlot(0)))).findFirst();
        if (recipe.isPresent()) {
            this.recipe = (InfusionRecipe)recipe.get().value();
            this.essenceCost = ((InfusionRecipe)recipe.get().value()).getEssenceCost();
        } else {
            this.recipe = null;
        }
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, InfuserBlockEntity pBlockEntity) {
        if (!pLevel.isClientSide()) {
            BufferUtil.getEssenceFromBuffersBelow((BlockEntity)pBlockEntity, List.of(EssenceTypeRegistry.ESSENCE.get(), EssenceTypeRegistry.LUNAR_ESSENCE.get(), EssenceTypeRegistry.NATURAL_ESSENCE.get(), EssenceTypeRegistry.EXOTIC_ESSENCE.get()));
            BufferUtil.getItemsFromBuffersBelow(pBlockEntity, (IItemHandler)pBlockEntity.itemHandler);
            pBlockEntity.item = pBlockEntity.itemHandler.getStackInSlot(0);
            boolean shouldReset = true;
            if (pBlockEntity.recipe != null) {
                Entry entry;
                boolean enoughEssence = true;
                for (Map.Entry<ResourceLocation, Float> i : pBlockEntity.essenceCost.entrySet()) {
                    EssenceType essenceType = (EssenceType)DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.get(i.getKey());
                    if (!(pBlockEntity.storage.getEssence(essenceType) < i.getValue().floatValue() / 50.0f)) continue;
                    enoughEssence = false;
                }
                if (enoughEssence && (entry = DataDrive.getEntry(pBlockEntity.dataDriveHandler.getStackInSlot(0))) != null && pBlockEntity.dataDriveHandler.getStackInSlot(0).has(DataComponentRegistry.DATA_ID) && pBlockEntity.dataDriveHandler.getStackInSlot(0).has(DataComponentRegistry.DATA_INCOMPLETE) && (pBlockEntity.recipe == null || pBlockEntity.recipe.getEntry().equals((Object)entry.id) && DataDrive.getEntryCompletionStage(pBlockEntity.dataDriveHandler.getStackInSlot(0)) >= pBlockEntity.recipe.getCompletionStage()) && InfuserBlockEntity.hasNotReachedStackLimit(pBlockEntity, pBlockEntity.recipe.getResultItem((HolderLookup.Provider)pLevel.registryAccess()))) {
                    for (Map.Entry entry2 : pBlockEntity.essenceCost.entrySet()) {
                        EssenceType type = (EssenceType)DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.get((ResourceLocation)entry2.getKey());
                        pBlockEntity.storage.removeEssence(type, ((Float)entry2.getValue()).floatValue() / 50.0f);
                    }
                    if (pBlockEntity.workTime >= 50) {
                        ItemStack stack = pBlockEntity.recipe.assemble(pBlockEntity.getCraftingInv(), (HolderLookup.Provider)pLevel.registryAccess()).copy();
                        pBlockEntity.outputItemHandler.insertItem(0, stack, false);
                        pBlockEntity.itemHandler.extractItem(0, 1, false);
                        pLevel.playSound(null, pPos, (SoundEvent)SoundRegistry.INFUSER_CRAFT.value(), SoundSource.BLOCKS, 2.0f, 1.0f);
                        pBlockEntity.workTime = 0;
                    } else {
                        ++pBlockEntity.workTime;
                    }
                    shouldReset = false;
                }
                pBlockEntity.enoughEssence = enoughEssence;
            }
            if (shouldReset) {
                pBlockEntity.workTime = -1;
            }
            pBlockEntity.updateBlock();
        } else if (pBlockEntity.workTime >= 0 && pBlockEntity.essenceCost != null) {
            ArrayList<EssenceType> essences = new ArrayList<EssenceType>();
            for (Map.Entry<ResourceLocation, Float> i : pBlockEntity.essenceCost.entrySet()) {
                if (!(i.getValue().floatValue() > 0.0f)) continue;
                EssenceType type = (EssenceType)DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.get(i.getKey());
                essences.add(type);
            }
            if (!essences.isEmpty()) {
                if (essences.size() == 1) {
                    ConfigurableParticleOptions options = new CircleParticleOptions().setFriction(0.8f).setColor(new Color(((EssenceType)essences.getFirst()).color)).setAdditive(false).setFullbright(true);
                    Vec3 pos = pPos.getBottomCenter();
                    Vec3 spd = pos.vectorTo(pPos.getCenter()).scale(0.2);
                    pLevel.addParticle((ParticleOptions)options, pos.x, pos.y, pos.z, spd.x, spd.y, spd.z);
                } else {
                    float rot = 45.0f;
                    for (EssenceType i : essences) {
                        ConfigurableParticleOptions configurableParticleOptions = new CircleParticleOptions().setFriction(0.8f).setColor(new Color(i.color)).setAdditive(false).setFullbright(true);
                        Vec3 pos = pPos.getBottomCenter().add(Vec3.directionFromRotation((float)0.0f, (float)rot).scale(0.4));
                        Vec3 spd = pos.vectorTo(pPos.getCenter()).scale(0.2);
                        pLevel.addParticle((ParticleOptions)configurableParticleOptions, pos.x, pos.y, pos.z, spd.x, spd.y, spd.z);
                        rot += 360.0f / (float)essences.size();
                    }
                }
            }
        }
    }

    protected void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new InfuserMenu(pContainerId, pInventory, this);
    }

    private static boolean hasNotReachedStackLimit(InfuserBlockEntity entity, ItemStack toAdd) {
        if (toAdd.is(entity.outputItemHandler.getStackInSlot(0).getItem())) {
            return entity.outputItemHandler.getStackInSlot(0).getCount() + toAdd.getCount() <= entity.outputItemHandler.getStackInSlot(0).getMaxStackSize();
        }
        return entity.outputItemHandler.getStackInSlot(0).isEmpty();
    }
}

