/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.production;

import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.container.SingleEssenceContainer;
import com.cmdpro.datanessence.block.production.EssenceBreaker;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class EssenceBreakerBlockEntity
extends BlockEntity
implements EssenceBlockEntity {
    public SingleEssenceContainer storage = new SingleEssenceContainer(EssenceTypeRegistry.ESSENCE.get(), 500.0f);
    private final float breakCost = 25.0f;
    public int interval;

    public EssenceBreakerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntityRegistry.ESSENCE_BREAKER.get(), pPos, pBlockState);
    }

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, EssenceBreakerBlockEntity tile) {
        if (!world.isClientSide()) {
            if (tile.interval <= 0) {
                BlockPos breakPos;
                BlockState breakState;
                if (!world.hasNeighborSignal(pos) && tile.getStorage().getEssence(EssenceTypeRegistry.ESSENCE.get()) >= tile.breakCost && ((breakState = world.getBlockState(breakPos = pos.relative((Direction)state.getValue((Property)EssenceBreaker.FACING)))).is(BlockTags.MINEABLE_WITH_PICKAXE) || breakState.is(BlockTags.MINEABLE_WITH_AXE) || breakState.is(BlockTags.MINEABLE_WITH_HOE) || breakState.is(BlockTags.MINEABLE_WITH_SHOVEL)) && !breakState.is(BlockTags.INCORRECT_FOR_DIAMOND_TOOL) && !(breakState.getDestroySpeed((BlockGetter)world, breakPos) <= -1.0f)) {
                    world.destroyBlock(breakPos, true);
                    ((ServerLevel)world).sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, breakPos.getCenter().x, breakPos.getCenter().y, breakPos.getCenter().z, 1, 0.0, 0.0, 0.0, 0.0);
                    tile.getStorage().removeEssence(EssenceTypeRegistry.ESSENCE.get(), tile.breakCost);
                    tile.interval = 20;
                }
            } else {
                --tile.interval;
            }
        }
    }

    public void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("BreakInterval", this.interval);
        super.saveAdditional(tag, provider);
    }

    public void loadAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        this.storage.fromNbt(tag.getCompound("EssenceStorage"));
        this.interval = tag.getInt("BreakInterval");
        super.loadAdditional(tag, provider);
    }

    @Override
    public float getMeterSideLength(Direction direction) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)EssenceBreaker.FACING);
        if (direction.equals((Object)facing)) {
            return EssenceBlockEntity.super.getMeterSideLength(direction) * 1.5f;
        }
        return EssenceBlockEntity.super.getMeterSideLength(direction);
    }
}

