/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.production;

import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.container.SingleEssenceContainer;
import com.cmdpro.datanessence.block.production.FluidCollector;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class FluidSpillerBlockEntity
extends BlockEntity
implements EssenceBlockEntity {
    public SingleEssenceContainer storage = new SingleEssenceContainer(EssenceTypeRegistry.ESSENCE.get(), 1000.0f);
    private final FluidTank fluidHandler = new FluidTank(4000);
    public int cooldown;

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public FluidSpillerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.FLUID_SPILLER.get(), pos, state);
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.put("fluid", (Tag)this.fluidHandler.writeToNBT(pRegistries, new CompoundTag()));
        tag.putInt("cooldown", this.cooldown);
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.fluidHandler.readFromNBT(pRegistries, nbt.getCompound("fluid"));
        this.storage.fromNbt(nbt.getCompound("EssenceStorage"));
        this.cooldown = nbt.getInt("cooldown");
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, FluidSpillerBlockEntity pBlockEntity) {
        if (!pLevel.isClientSide()) {
            if (pBlockEntity.cooldown <= 0) {
                if (pBlockEntity.getStorage().getEssence(EssenceTypeRegistry.ESSENCE.get()) >= 25.0f) {
                    BlockPos pos = pPos.relative((Direction)pState.getValue((Property)FluidCollector.FACING));
                    FluidState state = pLevel.getFluidState(pos);
                    BlockState state2 = pLevel.getBlockState(pos);
                    FluidStack stack = new FluidStack(pBlockEntity.fluidHandler.getFluid().getFluid(), 1000);
                    if ((state.isEmpty() || !state.isSource()) && state2.canBeReplaced(stack.getFluid()) && pBlockEntity.fluidHandler.getFluidAmount() >= 1000) {
                        pBlockEntity.fluidHandler.drain(stack, IFluidHandler.FluidAction.EXECUTE);
                        pLevel.setBlockAndUpdate(pos, stack.getFluid().defaultFluidState().createLegacyBlock());
                        pLevel.playSound(null, pPos, (SoundEvent)SoundRegistry.FLUID_SPILLER_EMPTY.value(), SoundSource.BLOCKS, 2.0f, 1.0f);
                        pBlockEntity.getStorage().removeEssence(EssenceTypeRegistry.ESSENCE.get(), 25.0f);
                    }
                }
            } else {
                --pBlockEntity.cooldown;
            }
        }
    }
}

