/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.production;

import com.cmdpro.databank.model.animation.DatabankAnimationReference;
import com.cmdpro.databank.model.animation.DatabankAnimationState;
import com.cmdpro.datanessence.api.block.Machine;
import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.container.SingleEssenceContainer;
import com.cmdpro.datanessence.api.util.BufferUtil;
import com.cmdpro.datanessence.client.FactorySong;
import com.cmdpro.datanessence.recipe.MetalShaperRecipe;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.DataComponentRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import com.cmdpro.datanessence.screen.MetalShaperMenu;
import java.util.List;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetalShaperBlockEntity
extends BlockEntity
implements MenuProvider,
EssenceBlockEntity,
Machine {
    public SingleEssenceContainer storage = new SingleEssenceContainer(EssenceTypeRegistry.ESSENCE.get(), 1000.0f);
    public DatabankAnimationState animState = new DatabankAnimationState("idle").addAnim(new DatabankAnimationReference("idle", (state, anim) -> {}, (state, anim) -> {})).addAnim(new DatabankAnimationReference("raise_press", (state, anim) -> {}, (state, anim) -> {})).addAnim(new DatabankAnimationReference("lower_press", (state, anim) -> {}, (state, anim) -> {}));
    public AnimationDefinition anim;
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            MetalShaperBlockEntity.this.setChanged();
            MetalShaperBlockEntity.this.checkRecipes();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return super.isItemValid(slot, stack);
        }
    };
    private final ItemStackHandler moldHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            MetalShaperBlockEntity.this.setChanged();
            MetalShaperBlockEntity.this.checkRecipes();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.has(DataComponentRegistry.MOLD);
        }
    };
    private final ItemStackHandler outputItemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            MetalShaperBlockEntity.this.setChanged();
        }
    };
    private final CombinedInvWrapper combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler, this.moldHandler, this.outputItemHandler});
    public ItemStack item = ItemStack.EMPTY;
    public MetalShaperRecipe recipe;
    public int workTime;
    public int maxWorkTime;

    public void setLevel(Level level) {
        super.setLevel(level);
        this.animState.setLevel(level);
    }

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public void drops() {
        SimpleContainer inventory = this.getInv();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public IItemHandler getMoldHandler() {
        return this.moldHandler;
    }

    public IItemHandler getOutputHandler() {
        return this.outputItemHandler;
    }

    public CombinedInvWrapper getCombinedInvWrapper() {
        return this.combinedInvWrapper;
    }

    public MetalShaperBlockEntity(BlockPos pos, BlockState state2) {
        super(BlockEntityRegistry.METAL_SHAPER.get(), pos, state2);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide) {
            this.checkRecipes();
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        this.storage.fromNbt(tag.getCompound("EssenceStorage"));
        this.item = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)tag.getCompound("item"));
        this.workTime = tag.getInt("workTime");
        this.itemHandler.deserializeNBT(pRegistries, tag.getCompound("itemHandler"));
        this.maxWorkTime = tag.getInt("maxWorkTime");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.put("item", this.item.saveOptional(pRegistries));
        tag.putInt("workTime", this.workTime);
        tag.putInt("maxWorkTime", this.recipe == null ? -1 : this.recipe.getTime());
        tag.put("itemHandler", (Tag)this.itemHandler.serializeNBT(pRegistries));
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.put("inventoryOutput", (Tag)this.outputItemHandler.serializeNBT(pRegistries));
        tag.put("inventoryDrive", (Tag)this.moldHandler.serializeNBT(pRegistries));
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("workTime", this.workTime);
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("inventory"));
        this.outputItemHandler.deserializeNBT(pRegistries, nbt.getCompound("inventoryOutput"));
        this.moldHandler.deserializeNBT(pRegistries, nbt.getCompound("inventoryDrive"));
        this.storage.fromNbt(nbt.getCompound("EssenceStorage"));
        this.workTime = nbt.getInt("workTime");
    }

    public SimpleContainer getInv() {
        int i;
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots() + this.outputItemHandler.getSlots() + this.moldHandler.getSlots());
        for (i = 0; i < this.moldHandler.getSlots(); ++i) {
            inventory.setItem(i, this.moldHandler.getStackInSlot(i));
        }
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i + this.moldHandler.getSlots(), this.itemHandler.getStackInSlot(i));
        }
        for (i = 0; i < this.outputItemHandler.getSlots(); ++i) {
            inventory.setItem(i + this.moldHandler.getSlots() + this.itemHandler.getSlots(), this.outputItemHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public RecipeInput getCraftingInv() {
        RecipeInput inventory = new RecipeInput(){

            public ItemStack getItem(int pIndex) {
                return MetalShaperBlockEntity.this.itemHandler.getStackInSlot(pIndex);
            }

            public int size() {
                return 1;
            }
        };
        return inventory;
    }

    public void checkRecipes() {
        List recipes = this.level.getRecipeManager().getRecipesFor(RecipeRegistry.METAL_SHAPING_TYPE.get(), this.getCraftingInv(), this.level);
        RecipeHolder recipe = null;
        ResourceLocation moldRecipe = null;
        if (!this.moldHandler.getStackInSlot(0).isEmpty()) {
            moldRecipe = (ResourceLocation)this.moldHandler.getStackInSlot(0).get(DataComponentRegistry.MOLD);
        }
        for (RecipeHolder i : recipes) {
            if (!i.id().equals((Object)moldRecipe)) continue;
            recipe = i;
        }
        if (recipe != null) {
            if (!((MetalShaperRecipe)recipe.value()).equals(this.recipe)) {
                this.workTime = 0;
            }
            this.recipe = (MetalShaperRecipe)recipe.value();
        } else {
            this.recipe = null;
        }
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, MetalShaperBlockEntity pBlockEntity) {
        if (!pLevel.isClientSide()) {
            ItemStack assembled;
            BufferUtil.getEssenceFromBuffersBelow((BlockEntity)pBlockEntity, EssenceTypeRegistry.ESSENCE.get());
            BufferUtil.getItemsFromBuffersBelow(pBlockEntity, (IItemHandler)pBlockEntity.itemHandler);
            boolean resetWorkTime = true;
            if (pBlockEntity.recipe != null && pBlockEntity.getStorage().getEssence(EssenceTypeRegistry.ESSENCE.get()) > 0.0f && pBlockEntity.outputItemHandler.insertItem(0, assembled = pBlockEntity.recipe.assemble(pBlockEntity.getCraftingInv(), (HolderLookup.Provider)pLevel.registryAccess()), true).isEmpty()) {
                resetWorkTime = false;
                if (pLevel.random.nextInt() % 20 == 0) {
                    pLevel.playSound(null, pPos, (SoundEvent)SoundRegistry.METAL_SHAPER_CRAFTING.value(), SoundSource.BLOCKS, 0.4f, 1.0f);
                    ((ServerLevel)pLevel).sendParticles((ParticleOptions)ParticleTypes.SMOKE, pPos.getCenter().x, pPos.getCenter().y, pPos.getCenter().z, 5, 0.0, 0.0, 0.0, 0.0);
                }
                ++pBlockEntity.workTime;
                pBlockEntity.getStorage().removeEssence(EssenceTypeRegistry.ESSENCE.get(), 1.0f);
                if (pBlockEntity.workTime >= pBlockEntity.recipe.getTime()) {
                    pBlockEntity.outputItemHandler.insertItem(0, assembled, false);
                    pBlockEntity.itemHandler.extractItem(0, 1, false);
                    pBlockEntity.workTime = 0;
                }
            }
            if (resetWorkTime) {
                pBlockEntity.workTime = -1;
            }
            pBlockEntity.updateBlock();
        } else if (pBlockEntity.workTime >= 0) {
            ClientHandler.markFactorySong(pPos);
        }
    }

    @Override
    public float getMeterSideLength(Direction direction) {
        if (direction.equals((Object)Direction.UP)) {
            return EssenceBlockEntity.super.getMeterSideLength(direction) * 1.5f;
        }
        return EssenceBlockEntity.super.getMeterSideLength(direction);
    }

    protected void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new MetalShaperMenu(pContainerId, pInventory, this);
    }

    @Override
    public List<Direction> getValidInputDirections() {
        return List.of(Direction.DOWN, Direction.EAST, Direction.WEST);
    }

    private static class ClientHandler {
        static FactorySong.FactoryLoop workingSound = FactorySong.getLoop((SoundEvent)SoundRegistry.METAL_SHAPER_LOOP.value());

        private ClientHandler() {
        }

        public static void markFactorySong(BlockPos pos) {
            workingSound.addSource(pos);
        }
    }
}

