/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.storage;

import com.cmdpro.datanessence.block.storage.EssenceBatteryBlockEntity;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EssenceBattery
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public EssenceBattery(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new EssenceBatteryBlockEntity(pPos, pState);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof EssenceBatteryBlockEntity) {
            EssenceBatteryBlockEntity ent = (EssenceBatteryBlockEntity)blockEntity;
            if (!pLevel.isClientSide) {
                pPlayer.displayClientMessage((Component)Component.translatable((String)"block.datanessence.essence_battery.amount", (Object[])new Object[]{Float.valueOf(ent.storage.getEssence(EssenceTypeRegistry.ESSENCE.get())), Float.valueOf(ent.storage.getMaxEssence())}), true);
            }
            return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        return super.useWithoutItem(pState, pLevel, pPos, pPlayer, pHitResult);
    }
}

