/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.storage;

import com.cmdpro.datanessence.api.util.TextUtil;
import com.cmdpro.datanessence.block.storage.FluidTankBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidTank
extends TransparentBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public FluidTank(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new FluidTankBlockEntity(pPos, pState);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof FluidTankBlockEntity) {
            FluidTankBlockEntity ent = (FluidTankBlockEntity)blockEntity;
            if (!pLevel.isClientSide) {
                FluidStack fluid = ent.getFluidHandler().getFluidInTank(0);
                if (fluid.getAmount() > 0) {
                    pPlayer.displayClientMessage((Component)Component.translatable((String)"block.datanessence.fluid_tank.amount", (Object[])new Object[]{TextUtil.getFluidText(fluid.getAmount()), TextUtil.getFluidText(ent.getFluidHandler().getTankCapacity(0)), fluid.getHoverName()}), true);
                } else {
                    pPlayer.displayClientMessage((Component)Component.translatable((String)"block.datanessence.fluid_tank.nothing"), true);
                }
            }
            return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        return super.useWithoutItem(pState, pLevel, pPos, pPlayer, pHitResult);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        FluidTankBlockEntity ent;
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof FluidTankBlockEntity && FluidUtil.interactWithFluidHandler((Player)pPlayer, (InteractionHand)pHand, (IFluidHandler)(ent = (FluidTankBlockEntity)blockEntity).getFluidHandler())) {
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }
}

