/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.storage;

import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class FluidTankBlockEntity
extends BlockEntity {
    private final FluidTank fluidHandler = new FluidTank(16000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            FluidTankBlockEntity.this.updateBlock();
        }
    };

    protected void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        this.fluidHandler.readFromNBT(pRegistries, tag.getCompound("fluid"));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.put("fluid", (Tag)this.fluidHandler.writeToNBT(pRegistries, new CompoundTag()));
        return tag;
    }

    public FluidTankBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.FLUID_TANK.get(), pos, state);
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("fluid", (Tag)this.fluidHandler.writeToNBT(pRegistries, new CompoundTag()));
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.fluidHandler.readFromNBT(pRegistries, nbt.getCompound("fluid"));
    }
}

