/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.technical;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.util.ComputerUtil;
import com.cmdpro.datanessence.block.technical.ComputerBlockEntity;
import com.cmdpro.datanessence.data.computers.ComputerTypeManager;
import com.cmdpro.datanessence.registry.ItemRegistry;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Computer
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public Computer(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        if (!pLevel.isClientSide) {
            this.giveLocator(pLevel, pPos, pPlayer);
            BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
            if (blockEntity instanceof ComputerBlockEntity) {
                ComputerBlockEntity ent = (ComputerBlockEntity)blockEntity;
                if (ent.type != null && ComputerTypeManager.types.containsKey(ent.type)) {
                    ComputerUtil.openComputer(pPlayer, ComputerTypeManager.types.get(ent.type));
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
    }

    public void giveLocator(Level world, BlockPos pos, Player player) {
        ItemStack signalTracker = new ItemStack((ItemLike)ItemRegistry.LOCATOR.get(), 1);
        ServerLevel serverWorld = (ServerLevel)world;
        boolean hasGottenDataTablet = false;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AdvancementHolder advancement = serverWorld.getServer().getAdvancements().get(DataNEssence.locate("datanessence"));
            if (advancement != null) {
                hasGottenDataTablet = serverPlayer.getAdvancements().getOrStartProgress(advancement).isDone();
            }
        }
        if (!player.getInventory().contains(signalTracker) && !hasGottenDataTablet) {
            player.addItem(signalTracker);
            player.displayClientMessage((Component)Component.translatable((String)"block.datanessence.computer.obtain_signal_tracker"), true);
            world.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS);
        }
    }

    public float getDestroyProgress(BlockState pState, Player pPlayer, BlockGetter pLevel, BlockPos pPos) {
        if (!pPlayer.isShiftKeyDown()) {
            return 0.0f;
        }
        return super.getDestroyProgress(pState, pPlayer, pLevel, pPos);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ComputerBlockEntity(pPos, pState);
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }
}

