/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.transmission;

import com.cmdpro.datanessence.api.MultiFluidTankNoDuplicateFluids;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public class FluidBufferBlockEntity
extends BlockEntity {
    private final MultiFluidTankNoDuplicateFluids fluidHandler = new MultiFluidTankNoDuplicateFluids(List.of(new FluidTank(1000), new FluidTank(1000), new FluidTank(1000), new FluidTank(1000), new FluidTank(1000), new FluidTank(1000)));

    public FluidBufferBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntityRegistry.FLUID_BUFFER.get(), pPos, pBlockState);
    }

    public FluidBufferBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public boolean transfer(IFluidHandler handler) {
        boolean transferredSomething = false;
        IFluidHandler resolved = this.getFluidHandler();
        for (int o = 0; o < resolved.getTanks(); ++o) {
            FluidStack copy = resolved.getFluidInTank(o).copy();
            if (copy.isEmpty()) continue;
            copy.setAmount(Math.clamp((int)0, (int)4000, (int)copy.getAmount()));
            int filled = handler.fill(copy, IFluidHandler.FluidAction.EXECUTE);
            if (filled > 0) {
                transferredSomething = true;
            }
            resolved.getFluidInTank(o).shrink(filled);
        }
        return transferredSomething;
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("fluid", (Tag)this.fluidHandler.writeToNBT(pRegistries, new CompoundTag()));
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.fluidHandler.readFromNBT(pRegistries, nbt.getCompound("fluid"));
    }
}

