/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.transmission;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.node.ICustomFluidPointBehaviour;
import com.cmdpro.datanessence.api.node.block.BaseCapabilityPointBlockEntity;
import com.cmdpro.datanessence.config.DataNEssenceConfig;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import java.awt.Color;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jgrapht.GraphPath;
import org.jgrapht.graph.DefaultEdge;
import org.joml.Math;

public class FluidPointBlockEntity
extends BaseCapabilityPointBlockEntity {
    public FluidPointBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.FLUID_POINT.get(), pos, state);
    }

    @Override
    public Color linkColor() {
        return new Color(5683945);
    }

    @Override
    public void transfer(BaseCapabilityPointBlockEntity from, List<GraphPath<BlockPos, DefaultEdge>> other) {
        int transferAmount = (int)Math.floor((float)((float)this.getFinalSpeed(DataNEssenceConfig.fluidPointTransfer) / (float)other.size()));
        for (GraphPath<BlockPos, DefaultEdge> i : other) {
            ICustomFluidPointBehaviour behaviour;
            BlockEntity value;
            BlockEntity blockEntity = this.level.getBlockEntity((BlockPos)i.getEndVertex());
            if (!(blockEntity instanceof BaseCapabilityPointBlockEntity)) continue;
            BaseCapabilityPointBlockEntity ent = (BaseCapabilityPointBlockEntity)blockEntity;
            BlockEntity allowedFluidstacks = null;
            for (BlockPos j : i.getVertexList()) {
                BlockEntity blockEntity2 = this.level.getBlockEntity(j);
                if (!(blockEntity2 instanceof BaseCapabilityPointBlockEntity)) continue;
                BaseCapabilityPointBlockEntity ent2 = (BaseCapabilityPointBlockEntity)blockEntity2;
                value = ent2.getValue(DataNEssence.locate("allowed_fluidstacks"), null);
                if (allowedFluidstacks == null) {
                    allowedFluidstacks = value;
                    continue;
                }
                if (value == null) continue;
                allowedFluidstacks = allowedFluidstacks.stream().filter(arg_0 -> FluidPointBlockEntity.lambda$transfer$1((List)value, arg_0)).toList();
            }
            IFluidHandler resolved = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, ent.getBlockPos().relative(ent.getDirection().getOpposite()), (Object)ent.getDirection());
            IFluidHandler resolved2 = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, from.getBlockPos().relative(from.getDirection().getOpposite()), (Object)from.getDirection());
            if (resolved == null || resolved2 == null || (value = this.level.getBlockEntity(from.getBlockPos().relative(from.getDirection().getOpposite()))) instanceof ICustomFluidPointBehaviour && !(behaviour = (ICustomFluidPointBehaviour)value).canExtractFluid(resolved, resolved2) || (value = this.level.getBlockEntity(ent.getBlockPos().relative(ent.getDirection().getOpposite()))) instanceof ICustomFluidPointBehaviour && !(behaviour = (ICustomFluidPointBehaviour)value).canInsertFluid(resolved, resolved2)) continue;
            for (int o = 0; o < resolved2.getTanks(); ++o) {
                FluidStack copy = resolved2.getFluidInTank(o).copy();
                if (allowedFluidstacks != null && allowedFluidstacks.stream().noneMatch(stack -> FluidStack.isSameFluid((FluidStack)stack, (FluidStack)copy)) || copy.isEmpty()) continue;
                copy.setAmount(Math.clamp((int)0, (int)transferAmount, (int)copy.getAmount()));
                int filled = resolved.fill(copy, IFluidHandler.FluidAction.EXECUTE);
                resolved2.drain(new FluidStack(copy.getFluid(), filled), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    private static /* synthetic */ boolean lambda$transfer$1(List value, FluidStack stack1) {
        return value.stream().anyMatch(stack2 -> FluidStack.isSameFluid((FluidStack)stack1, (FluidStack)stack2));
    }
}

