/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.transmission;

import com.cmdpro.datanessence.api.LockableItemHandler;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public class ItemBufferBlockEntity
extends BlockEntity {
    private final ItemStackHandler itemHandler = this.createItemHandler();

    public ItemStackHandler createItemHandler() {
        return new ItemStackHandler(15){

            protected void onContentsChanged(int slot) {
                ItemBufferBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                for (int i = 0; i < this.getSlots(); ++i) {
                    if (i == slot) {
                        if (!ItemStack.isSameItemSameComponents((ItemStack)this.getStackInSlot(slot), (ItemStack)stack)) continue;
                        return super.isItemValid(slot, stack);
                    }
                    if (!ItemStack.isSameItemSameComponents((ItemStack)this.getStackInSlot(i), (ItemStack)stack)) continue;
                    return false;
                }
                return super.isItemValid(slot, stack);
            }
        };
    }

    public ItemBufferBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntityRegistry.ITEM_BUFFER.get(), pPos, pBlockState);
    }

    public ItemBufferBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public boolean transfer(IItemHandler handler) {
        IItemHandler resolved = this.getItemHandler();
        boolean movedAnything = false;
        for (int o = 0; o < resolved.getSlots(); ++o) {
            ItemStack copy = resolved.getStackInSlot(o).copy();
            if (copy.isEmpty()) continue;
            copy.setCount(Math.clamp((int)0, (int)16, (int)copy.getCount()));
            ItemStack copy2 = copy.copy();
            for (int p = 0; p < handler.getSlots(); ++p) {
                ItemStack copyCopy = copy.copy();
                boolean canInsert = true;
                if (handler instanceof LockableItemHandler) {
                    LockableItemHandler lockable = (LockableItemHandler)handler;
                    canInsert = lockable.canInsertFromBuffer(p, copyCopy);
                }
                if (!canInsert) continue;
                int remove = handler.insertItem(p, copyCopy, false).getCount();
                if (remove < copyCopy.getCount()) {
                    movedAnything = true;
                }
                copy.setCount(remove);
                if (remove <= 0) break;
            }
            if (!movedAnything) continue;
            resolved.extractItem(o, copy2.getCount() - copy.getCount(), false);
            break;
        }
        return movedAnything;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("inventory"));
    }

    public void drops() {
        SimpleContainer inventory = this.getInv();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public SimpleContainer getInv() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        return inventory;
    }
}

