/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.transmission;

import com.cmdpro.datanessence.block.transmission.ItemFilterBlockEntity;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.IntegerRange;
import org.jetbrains.annotations.Nullable;

public class ItemFilter
extends Block
implements EntityBlock {
    public static final HashMap<Direction, IntegerRange> DIRECTIONS = new HashMap<Direction, IntegerRange>(){
        {
            this.put(Direction.UP, IntegerRange.of((int)0, (int)8));
            this.put(Direction.DOWN, IntegerRange.of((int)9, (int)17));
            this.put(Direction.NORTH, IntegerRange.of((int)18, (int)26));
            this.put(Direction.SOUTH, IntegerRange.of((int)27, (int)35));
            this.put(Direction.EAST, IntegerRange.of((int)36, (int)44));
            this.put(Direction.WEST, IntegerRange.of((int)45, (int)53));
        }
    };
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public ItemFilter(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        if (!pLevel.isClientSide()) {
            BlockEntity entity = pLevel.getBlockEntity(pPos);
            if (entity instanceof ItemFilterBlockEntity) {
                ItemFilterBlockEntity ent = (ItemFilterBlockEntity)entity;
                pPlayer.openMenu((MenuProvider)ent, pPos);
            } else {
                throw new IllegalStateException("Our Container provider is missing!");
            }
        }
        return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ItemFilterBlockEntity(pPos, pState);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof ItemFilterBlockEntity) {
            ((ItemFilterBlockEntity)blockEntity).drops();
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return (lvl, pos, st, blockEntity) -> {
            if (blockEntity instanceof ItemFilterBlockEntity) {
                ItemFilterBlockEntity ent = (ItemFilterBlockEntity)blockEntity;
                ItemFilterBlockEntity.tick(lvl, pos, st, ent);
            }
        };
    }
}

