/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.transmission;

import com.cmdpro.datanessence.api.node.ICustomItemPointBehaviour;
import com.cmdpro.datanessence.block.transmission.ItemFilter;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.screen.ItemFilterMenu;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.IntegerRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemFilterBlockEntity
extends BlockEntity
implements MenuProvider,
ICustomItemPointBehaviour {
    private final ItemStackHandler itemHandler = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            ItemFilterBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            boolean isValid = false;
            for (int i = 9 * slot; i < 9 * (slot + 1) - 1; ++i) {
                ItemStack stack2 = ItemFilterBlockEntity.this.filterHandler.getStackInSlot(i);
                if (!ItemFilterBlockEntity.filterMatches(stack, stack2)) continue;
                isValid = true;
                break;
            }
            if (!isValid) {
                return false;
            }
            return super.isItemValid(slot, stack);
        }
    };
    private final ItemStackHandler filterHandler = new ItemStackHandler(54){

        protected void onContentsChanged(int slot) {
            ItemFilterBlockEntity.this.setChanged();
        }
    };

    @Override
    public boolean canExtractItem(IItemHandler handler, IItemHandler other) {
        return false;
    }

    public SimpleContainer getInv() {
        int i;
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots() + this.filterHandler.getSlots());
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        for (i = 0; i < this.filterHandler.getSlots(); ++i) {
            inventory.setItem(i + this.itemHandler.getSlots(), this.filterHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public void drops() {
        SimpleContainer inventory = this.getInv();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public IItemHandler getFilterHandler() {
        return this.filterHandler;
    }

    public ItemFilterBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.ITEM_FILTER.get(), pos, state);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.put("filters", (Tag)this.filterHandler.serializeNBT(pRegistries));
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("inventory"));
        this.filterHandler.deserializeNBT(pRegistries, nbt.getCompound("filters"));
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, ItemFilterBlockEntity pBlockEntity) {
        if (!pLevel.isClientSide()) {
            pBlockEntity.tickInventory();
        }
    }

    public void tickInventory() {
        for (Map.Entry<Direction, IntegerRange> direction : ItemFilter.DIRECTIONS.entrySet()) {
            int index = (Integer)direction.getValue().getMinimum() / 9;
            BlockPos offset = this.getBlockPos().relative(direction.getKey());
            IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, offset, (Object)direction.getKey().getOpposite());
            if (itemHandler == null) continue;
            boolean movedAnything = false;
            ItemStack copy = this.itemHandler.getStackInSlot(index);
            if (copy.isEmpty()) continue;
            ItemStack copy2 = copy.copy();
            for (int p = 0; p < itemHandler.getSlots(); ++p) {
                ItemStack copyCopy = copy.copy();
                int remove = itemHandler.insertItem(p, copyCopy, false).getCount();
                if (remove < copyCopy.getCount()) {
                    movedAnything = true;
                }
                copy.setCount(remove);
                if (remove <= 0) break;
            }
            if (!movedAnything) continue;
            this.itemHandler.extractItem(index, copy2.getCount() - copy.getCount(), false);
            break;
        }
    }

    public static boolean filterMatches(ItemStack stack, ItemStack stack2) {
        if (stack.isEmpty() || stack2.isEmpty()) {
            return false;
        }
        return ItemStack.isSameItem((ItemStack)stack, (ItemStack)stack2);
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new ItemFilterMenu(pContainerId, pInventory, this);
    }
}

