/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.transportation;

import com.cmdpro.databank.model.animation.DatabankAnimationReference;
import com.cmdpro.databank.model.animation.DatabankAnimationState;
import com.cmdpro.datanessence.api.misc.BlockPosNetworks;
import com.cmdpro.datanessence.api.pearlnetwork.PearlNetworkBlockEntity;
import com.cmdpro.datanessence.block.transportation.EnderPearlDestinationBlockEntity;
import com.cmdpro.datanessence.networking.ModMessages;
import com.cmdpro.datanessence.networking.packet.s2c.vfx.PlayEnderPearlRedirectionEffect;
import com.cmdpro.datanessence.registry.AttachmentTypeRegistry;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;

public class EnderPearlCaptureBlockEntity
extends PearlNetworkBlockEntity {
    public DatabankAnimationState animState = new DatabankAnimationState("idle").addAnim(new DatabankAnimationReference("idle", (state, anim) -> {}, (state, anim) -> {}));

    public EnderPearlCaptureBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntityRegistry.ENDER_PEARL_CAPTURE.get(), pos, blockState);
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        this.animState.setLevel(level);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, EnderPearlCaptureBlockEntity pBlockEntity) {
        List pearls;
        if (!pLevel.isClientSide && !(pearls = pLevel.getEntitiesOfClass(ThrownEnderpearl.class, AABB.ofSize((Vec3)pPos.getCenter(), (double)5.0, (double)5.0, (double)5.0))).isEmpty()) {
            BlockPosNetworks networks = (BlockPosNetworks)pLevel.getData(AttachmentTypeRegistry.ENDER_PEARL_NETWORKS);
            ShortestPathAlgorithm.SingleSourcePaths paths = networks.path.getPaths((Object)pPos);
            List<GraphPath> ends = networks.graph.vertexSet().stream().filter(vertex -> networks.graph.edgesOf(vertex).stream().noneMatch(edge -> ((BlockPos)networks.graph.getEdgeSource(edge)).equals(vertex)) && paths.getPath(vertex) != null).map(arg_0 -> ((ShortestPathAlgorithm.SingleSourcePaths)paths).getPath(arg_0)).filter(i -> pLevel.getBlockEntity((BlockPos)i.getEndVertex()) instanceof EnderPearlDestinationBlockEntity).toList();
            if (!ends.isEmpty()) {
                for (ThrownEnderpearl i2 : pearls) {
                    Entity owner = i2.getOwner();
                    GraphPath end = ends.get(owner.getRandom().nextInt(0, ends.size()));
                    Vec3 pos = ((BlockPos)end.getEndVertex()).getCenter();
                    owner.teleportTo(pos.x, pos.y, pos.z);
                    List vertexes = end.getVertexList();
                    for (ServerPlayer j : ((ServerLevel)pLevel).players()) {
                        List<BlockPos> nodes = vertexes.stream().filter(block -> block.getCenter().distanceTo(j.position()) <= 64.0).toList();
                        PlayEnderPearlRedirectionEffect message = new PlayEnderPearlRedirectionEffect(nodes);
                        boolean canSend = !nodes.isEmpty();
                        if (!canSend) continue;
                        ModMessages.sendToPlayer(message, j);
                    }
                    i2.remove(Entity.RemovalReason.DISCARDED);
                }
            }
        }
    }
}

