/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client;

import com.cmdpro.databank.misc.SoundUtil;
import com.cmdpro.datanessence.config.DataNEssenceClientConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="datanessence")
public class FactorySong {
    public static final HashMap<ResourceLocation, FactoryLoop> FACTORY_LOOPS = new HashMap();
    private static float lastMasterVolume = 1.0f;
    public static int FactorySongPointer;

    public static void addFactorySongSound(ResourceLocation id) {
        FACTORY_LOOPS.put(id, new FactoryLoop(new FactorySoundInstance(id, SoundSource.MASTER, 0.5f, 1.0f, SoundInstance.createUnseededRandom(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true)));
    }

    public static FactoryLoop getLoop(SoundEvent event) {
        return FACTORY_LOOPS.get(event.getLocation());
    }

    @SubscribeEvent
    public static void handleFactorySong(ClientTickEvent.Post event) {
        Minecraft client = Minecraft.getInstance();
        SoundManager soundManager = client.getSoundManager();
        boolean playing = false;
        ArrayList<FactorySoundInstance> toSync = new ArrayList<FactorySoundInstance>();
        float currentVolume = client.options.getSoundSourceVolume(SoundSource.MASTER);
        boolean volumeJustCameBack = lastMasterVolume == 0.0f && currentVolume > 0.0f;
        lastMasterVolume = currentVolume;
        if (currentVolume > 0.0f || volumeJustCameBack) {
            for (FactoryLoop factoryLoop : FACTORY_LOOPS.values()) {
                boolean currentPlaying = false;
                if (soundManager.isActive((SoundInstance)factoryLoop.sound)) {
                    if (factoryLoop.getSourceCount() > 0) {
                        currentPlaying = true;
                    } else {
                        soundManager.stop((SoundInstance)factoryLoop.sound);
                    }
                } else if (factoryLoop.getSourceCount() > 0) {
                    currentPlaying = true;
                    soundManager.play((SoundInstance)factoryLoop.sound);
                    toSync.add(factoryLoop.sound);
                }
                if (currentPlaying) {
                    playing = true;
                    float volume = factoryLoop.sound.getDynamicVolume(factoryLoop.sound.getVolume());
                    if (SoundUtil.getChannelHandle((SoundInstance)factoryLoop.sound) == null) {
                        soundManager.play((SoundInstance)factoryLoop.sound);
                    } else {
                        SoundUtil.modifySound((SoundInstance)factoryLoop.sound, channel -> channel.setVolume(volume));
                    }
                }
                factoryLoop.clearSources();
            }
            if (playing && !client.isPaused()) {
                ++FactorySongPointer;
            }
            if (FactorySongPointer > 612 || !playing) {
                FactorySongPointer = 0;
            }
            for (SoundInstance soundInstance : toSync) {
                float time = (float)FactorySongPointer / 20.0f;
                SoundUtil.setTime((SoundInstance)soundInstance, (float)time);
            }
        }
    }

    public static class FactoryLoop {
        public FactorySoundInstance sound;
        private final List<BlockPos> sources = new ArrayList<BlockPos>();

        public FactoryLoop(FactorySoundInstance sound) {
            this.sound = sound;
            this.sound.loop = this;
        }

        public void clearSources() {
            this.sources.clear();
        }

        public void addSource(BlockPos pos) {
            if (!this.sources.contains(pos)) {
                this.sources.add(pos);
            }
        }

        public BlockPos getClosestSource(Vec3 pos) {
            double closestDist = Double.MAX_VALUE;
            BlockPos closest = null;
            for (BlockPos i : this.sources) {
                double dist = i.getCenter().distanceTo(pos);
                if (!(dist < closestDist)) continue;
                closest = i;
                closestDist = dist;
            }
            return closest;
        }

        public int getSourceCount() {
            return this.sources.size();
        }
    }

    public static class FactorySoundInstance
    extends SimpleSoundInstance {
        public FactoryLoop loop;

        public FactorySoundInstance(SoundEvent soundEvent, SoundSource source, float volume, float pitch, RandomSource random, BlockPos entity) {
            super(soundEvent, source, volume, pitch, random, entity);
        }

        public FactorySoundInstance(SoundEvent soundEvent, SoundSource source, float volume, float pitch, RandomSource random, double x, double y, double z) {
            super(soundEvent, source, volume, pitch, random, x, y, z);
        }

        public FactorySoundInstance(ResourceLocation location, SoundSource source, float volume, float pitch, RandomSource random, boolean looping, int delay, SoundInstance.Attenuation attenuation, double x, double y, double z, boolean relative) {
            super(location, source, volume, pitch, random, looping, delay, attenuation, x, y, z, relative);
        }

        public float getDynamicVolume(float original) {
            if (original <= 0.0f) {
                return 0.0f;
            }
            float masterVolume = Minecraft.getInstance().options.getSoundSourceVolume(SoundSource.MASTER);
            if (masterVolume <= 0.0f) {
                return 0.0f;
            }
            if (DataNEssenceClientConfig.factorySongVolume <= 0) {
                return 0.0f;
            }
            float volume = original;
            if (this.loop != null) {
                Vec3 eye = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                if (eye == null) {
                    return 0.0f;
                }
                BlockPos closest = this.loop.getClosestSource(eye);
                if (closest == null) {
                    return 0.0f;
                }
                Vec3 center = closest.getCenter();
                if (center == null) {
                    return 0.0f;
                }
                double maxDist = 25.0;
                double dist = center.distanceTo(eye);
                double clampedDist = Math.max(0.0, Math.min(maxDist, dist));
                volume *= (float)((maxDist - clampedDist) / maxDist);
                volume *= (float)DataNEssenceClientConfig.factorySongVolume * 0.01f;
            }
            return volume;
        }
    }
}

