/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.gui;

import com.cmdpro.databank.rendering.ColorUtil;
import com.cmdpro.databank.shaders.PostShaderManager;
import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.data.pinging.PingableStructure;
import com.cmdpro.datanessence.data.pinging.StructurePing;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class PingsGuiLayer
implements LayeredDraw.Layer {
    public static HashMap<StructurePing, Integer> pings = new HashMap();

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        for (Map.Entry<StructurePing, Integer> i : pings.entrySet()) {
            StructurePing ping = i.getKey();
            Vec3 pos = ping.pos.getCenter();
            pos = new Vec3(pos.x, Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().y, pos.z);
            PingableStructure structure = ping.getPingableStructure();
            PingableStructure.PingableStructureIcon icon = structure.icon;
            int width = guiGraphics.guiWidth();
            int height = guiGraphics.guiHeight();
            Vec2 screenPos = PingsGuiLayer.worldPosToTexCoord(pos.toVector3f(), width, height);
            if (screenPos == null) continue;
            int x = (int)screenPos.x - 8;
            int y = (int)screenPos.y - 8;
            Color color1 = ping.known ? structure.color1 : new Color(0xB100B1);
            Color color2 = ping.known ? structure.color2 : new Color(0xFF00FF);
            long gameTime = 0L;
            if (Minecraft.getInstance().level != null) {
                gameTime = Minecraft.getInstance().level.getGameTime();
            }
            Color color = ColorUtil.blendColors((Color)color1, (Color)color2, (float)((Math.sin((float)(((float)gameTime + Minecraft.getInstance().getTimer().getGameTimeDeltaTicks()) / 15.0f)) + 1.0f) / 2.0f));
            int u = icon.u;
            int v = icon.v;
            ResourceLocation texture = icon.texture;
            if (!i.getKey().known) {
                u = 0;
                v = 0;
                texture = DataNEssence.locate("textures/gui/structure_icons.png");
            }
            guiGraphics.setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
            guiGraphics.blit(texture, x, y, u, v, 16, 16);
            int distance = (int)Minecraft.getInstance().player.position().distanceTo(pos);
            distance = distance < 100 ? Mth.roundToward((int)distance, (int)10) : Mth.roundToward((int)distance, (int)100);
            Font font = Minecraft.getInstance().font;
            String text = distance + "m";
            guiGraphics.drawString(font, text, x + 8 - font.width(text) / 2, y + 17, color.getRGB(), false);
        }
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }

    public static Vec2 worldPosToTexCoord(Vector3f worldPos, int width, int height) {
        Matrix4f viewMat = PostShaderManager.viewStackMatrix;
        Matrix4f projMat = Minecraft.getInstance().gameRenderer.getProjectionMatrix((double)((Integer)Minecraft.getInstance().options.fov().get()).intValue());
        Vector3f localPos = new Vector3f((Vector3fc)worldPos);
        localPos.sub((Vector3fc)Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f());
        Vector4f pos = new Vector4f((Vector3fc)localPos, 1.0f);
        pos.mul((Matrix4fc)viewMat);
        pos.mul((Matrix4fc)projMat);
        if (pos.w <= 0.0f) {
            return null;
        }
        pos.div(pos.w);
        return new Vec2((pos.x + 1.0f) / 2.0f * (float)width, (1.0f - pos.y) / 2.0f * (float)height);
    }
}

