/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.renderers.block;

import com.cmdpro.databank.model.DatabankModel;
import com.cmdpro.databank.model.DatabankModels;
import com.cmdpro.databank.model.blockentity.DatabankBlockEntityModel;
import com.cmdpro.databank.model.blockentity.DatabankBlockEntityRenderer;
import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.block.processing.AutoFabricatorBlockEntity;
import com.cmdpro.datanessence.client.shaders.MachineOutputShader;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AutoFabricatorRenderer
extends DatabankBlockEntityRenderer<AutoFabricatorBlockEntity> {
    public AutoFabricatorRenderer(BlockEntityRendererProvider.Context rendererProvider) {
        super((DatabankBlockEntityModel)new Model());
    }

    public void render(AutoFabricatorBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        super.render((BlockEntity)pBlockEntity, pPartialTick, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay);
        pPoseStack.pushPose();
        pPoseStack.translate(0.5, 0.5, 0.5);
        pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(pBlockEntity.getLevel().getLevelData().getGameTime() % 360L) + pPartialTick));
        pPoseStack.scale(0.25f, 0.25f, 0.25f);
        Minecraft.getInstance().getItemRenderer().renderStatic(pBlockEntity.item, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, pPoseStack, (MultiBufferSource)MachineOutputShader.createMachineOutputBufferSource(), pBlockEntity.getLevel(), 0);
        pPoseStack.popPose();
    }

    public static class Model
    extends DatabankBlockEntityModel<AutoFabricatorBlockEntity> {
        public DatabankModel model;

        public ResourceLocation getTextureLocation() {
            return DataNEssence.locate("textures/block/auto-fabricator.png");
        }

        public void setupModelPose(AutoFabricatorBlockEntity pEntity, float partialTick) {
            pEntity.animState.updateAnimDefinitions(this.getModel());
            if (pEntity.craftingProgress >= 0) {
                pEntity.animState.setAnim("crafting");
            } else {
                pEntity.animState.setAnim("idle");
            }
            this.animate(pEntity.animState);
        }

        public DatabankModel getModel() {
            if (this.model == null) {
                this.model = (DatabankModel)DatabankModels.models.get(DataNEssence.locate("auto-fabricator"));
            }
            return this.model;
        }
    }
}

