/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.renderers.block;

import com.cmdpro.databank.model.DatabankModel;
import com.cmdpro.databank.model.DatabankModels;
import com.cmdpro.databank.model.blockentity.DatabankBlockEntityModel;
import com.cmdpro.databank.model.blockentity.DatabankBlockEntityRenderer;
import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.block.processing.FluidMixerBlockEntity;
import com.cmdpro.datanessence.util.RenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidMixerRenderer
extends DatabankBlockEntityRenderer<FluidMixerBlockEntity> {
    float itemAngle;

    public FluidMixerRenderer(BlockEntityRendererProvider.Context rendererProvider) {
        super((DatabankBlockEntityModel)new Model());
    }

    public void render(FluidMixerBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack item;
        IClientFluidTypeExtensions fluidTypeExtensions;
        ResourceLocation stillTexture;
        super.render((BlockEntity)blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        FluidStack fluid = blockEntity.getOutputHandler().getFluidInTank(0);
        int max = blockEntity.getOutputHandler().getTankCapacity(0);
        float fill = (float)fluid.getAmount() / (float)max;
        if (fill > 0.0f && (stillTexture = (fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid())).getStillTexture(fluid)) != null) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(stillTexture);
            int tintColor = fluidTypeExtensions.getTintColor(fluid);
            VertexConsumer builder = bufferSource.getBuffer(ItemBlockRenderTypes.getRenderLayer((FluidState)fluid.getFluid().defaultFluidState()));
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            poseStack.scale(0.87f, 0.8f, 0.87f);
            float u0 = sprite.getU0();
            float u1 = sprite.getU1();
            float v0 = sprite.getV0();
            float v1 = sprite.getV1();
            RenderHelper.renderQuad(builder, poseStack, -0.5f, -0.5f + fill, -0.5f, 0.5f, -0.5f + fill, 0.5f, u0, v0, u1, v1, packedLight, tintColor);
            v0 += (1.0f - fill) * (v1 - v0);
            RenderHelper.renderQuad(builder, poseStack, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f + fill, 0.5f, u0, v0, u1, v1, packedLight, tintColor);
            RenderHelper.renderQuad(builder, poseStack, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f + fill, -0.5f, u0, v0, u1, v1, packedLight, tintColor);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            RenderHelper.renderQuad(builder, poseStack, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f + fill, 0.5f, u0, v0, u1, v1, packedLight, tintColor);
            RenderHelper.renderQuad(builder, poseStack, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f + fill, -0.5f, u0, v0, u1, v1, packedLight, tintColor);
            poseStack.popPose();
        }
        if ((item = blockEntity.getItemHandler().getStackInSlot(0)) != ItemStack.EMPTY) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.scale(0.65f, 0.65f, 0.65f);
            if (blockEntity.animState.isCurrentAnim("working")) {
                this.itemAngle = -(((float)blockEntity.age + partialTick) / 20.0f / ((float)Math.PI * 2) * 360.0f);
            }
            poseStack.mulPose(Axis.YP.rotationDegrees(this.itemAngle));
            Minecraft.getInstance().getItemRenderer().renderStatic(item, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), 0);
            poseStack.popPose();
        }
    }

    public static class Model
    extends DatabankBlockEntityModel<FluidMixerBlockEntity> {
        public DatabankModel model;

        public ResourceLocation getTextureLocation() {
            return DataNEssence.locate("textures/block/fluid_mixer.png");
        }

        public void setupModelPose(FluidMixerBlockEntity pEntity, float partialTick) {
            pEntity.animState.updateAnimDefinitions(this.getModel());
            if (pEntity.workTime >= 0) {
                pEntity.animState.setAnim("working");
            } else {
                pEntity.animState.setAnim("idle");
            }
            this.animate(pEntity.animState);
        }

        public DatabankModel getModel() {
            if (this.model == null) {
                this.model = (DatabankModel)DatabankModels.models.get(DataNEssence.locate("fluid_mixer"));
            }
            return this.model;
        }
    }
}

