/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.renderers.block;

import com.cmdpro.datanessence.block.storage.FluidTankBlockEntity;
import com.cmdpro.datanessence.util.RenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidTankRenderer
implements BlockEntityRenderer<FluidTankBlockEntity> {
    EntityRenderDispatcher renderDispatcher;

    public void render(FluidTankBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        IClientFluidTypeExtensions fluidTypeExtensions;
        ResourceLocation stillTexture;
        FluidStack fluid = pBlockEntity.getFluidHandler().getFluidInTank(0);
        int max = pBlockEntity.getFluidHandler().getTankCapacity(0);
        float fill = (float)fluid.getAmount() / (float)max;
        if (fill > 0.0f && (stillTexture = (fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid())).getStillTexture(fluid)) != null) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(stillTexture);
            int tintColor = fluidTypeExtensions.getTintColor(fluid);
            VertexConsumer builder = pBuffer.getBuffer(ItemBlockRenderTypes.getRenderLayer((FluidState)fluid.getFluid().defaultFluidState()));
            pPoseStack.pushPose();
            pPoseStack.translate(0.5, 0.5, 0.5);
            pPoseStack.scale(0.999f, 0.999f, 0.999f);
            float u0 = sprite.getU0();
            float u1 = sprite.getU1();
            float v0 = sprite.getV0();
            float v1 = sprite.getV1();
            RenderHelper.renderQuad(builder, pPoseStack, -0.5f, -0.5f + fill, -0.5f, 0.5f, -0.5f + fill, 0.5f, u0, v0, u1, v1, pPackedLight, tintColor);
            v0 += (1.0f - fill) * (v1 - v0);
            RenderHelper.renderQuad(builder, pPoseStack, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f + fill, 0.5f, u0, v0, u1, v1, pPackedLight, tintColor);
            RenderHelper.renderQuad(builder, pPoseStack, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f + fill, -0.5f, u0, v0, u1, v1, pPackedLight, tintColor);
            pPoseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            RenderHelper.renderQuad(builder, pPoseStack, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f + fill, 0.5f, u0, v0, u1, v1, pPackedLight, tintColor);
            RenderHelper.renderQuad(builder, pPoseStack, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f + fill, -0.5f, u0, v0, u1, v1, pPackedLight, tintColor);
            pPoseStack.popPose();
        }
    }

    public FluidTankRenderer(BlockEntityRendererProvider.Context rendererProvider) {
        this.renderDispatcher = rendererProvider.getEntityRenderer();
    }
}

