/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.renderers.block;

import com.cmdpro.databank.model.DatabankModel;
import com.cmdpro.databank.model.DatabankModels;
import com.cmdpro.databank.model.blockentity.DatabankBlockEntityModel;
import com.cmdpro.databank.model.blockentity.DatabankBlockEntityRenderer;
import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.block.generation.IndustrialPlantSiphon;
import com.cmdpro.datanessence.block.generation.IndustrialPlantSiphonBlockEntity;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class IndustrialPlantSiphonRenderer
extends DatabankBlockEntityRenderer<IndustrialPlantSiphonBlockEntity> {
    public IndustrialPlantSiphonRenderer(BlockEntityRendererProvider.Context rendererProvider) {
        super((DatabankBlockEntityModel)new Model());
    }

    public void render(IndustrialPlantSiphonBlockEntity tile, float pPartialTick, PoseStack poseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Direction facing = (Direction)tile.getBlockState().getValue((Property)IndustrialPlantSiphon.FACING);
        Vec3 rotateAround = new Vec3(0.5, 0.5, 0.5);
        if (facing.equals((Object)Direction.NORTH)) {
            poseStack.rotateAround(Axis.YP.rotationDegrees(0.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
        }
        if (facing.equals((Object)Direction.SOUTH)) {
            poseStack.rotateAround(Axis.YP.rotationDegrees(180.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
        }
        if (facing.equals((Object)Direction.EAST)) {
            poseStack.rotateAround(Axis.YP.rotationDegrees(-90.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
        }
        if (facing.equals((Object)Direction.WEST)) {
            poseStack.rotateAround(Axis.YP.rotationDegrees(90.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
        }
        super.render((BlockEntity)tile, pPartialTick, poseStack, pBufferSource, pPackedLight, pPackedOverlay);
    }

    public static class Model
    extends DatabankBlockEntityModel<IndustrialPlantSiphonBlockEntity> {
        public DatabankModel model;

        public ResourceLocation getTextureLocation() {
            return DataNEssence.locate("textures/block/industrial_plant_siphon.png");
        }

        public void setupModelPose(IndustrialPlantSiphonBlockEntity pEntity, float partialTick) {
            pEntity.animState.updateAnimDefinitions(this.getModel());
            if (pEntity.essenceGenerationTicks > 0.0f && !(pEntity.storage.getEssence(EssenceTypeRegistry.ESSENCE.get()) + pEntity.generationRate > pEntity.storage.getMaxEssence())) {
                pEntity.animState.setAnim("working");
            } else {
                pEntity.animState.setAnim("idle");
            }
            this.animate(pEntity.animState);
        }

        public DatabankModel getModel() {
            if (this.model == null) {
                this.model = (DatabankModel)DatabankModels.models.get(DataNEssence.locate("industrial_plant_siphon"));
            }
            return this.model;
        }
    }
}

