/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.renderers.block;

import com.cmdpro.databank.misc.RenderingUtil;
import com.cmdpro.datanessence.api.item.ILaserEmitterModule;
import com.cmdpro.datanessence.block.auxiliary.LaserEmitterBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class LaserEmitterRenderer
implements BlockEntityRenderer<LaserEmitterBlockEntity> {
    EntityRenderDispatcher renderDispatcher;

    public void render(LaserEmitterBlockEntity laserEmitter, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (laserEmitter.end != null) {
            Vec3 pos = laserEmitter.getBlockPos().getCenter();
            poseStack.pushPose();
            poseStack.translate(-pos.x, -pos.y, -pos.z);
            poseStack.translate(0.5, 0.5, 0.5);
            int color = 14825199;
            Item item = laserEmitter.item.getItem();
            if (item instanceof ILaserEmitterModule) {
                ILaserEmitterModule lens = (ILaserEmitterModule)item;
                color = lens.getBeamColor();
            }
            RenderingUtil.renderAdvancedBeaconBeam((PoseStack)poseStack, (MultiBufferSource)bufferSource, (ResourceLocation)BeaconRenderer.BEAM_LOCATION, (float)partialTick, (float)1.0f, (long)laserEmitter.getLevel().getGameTime(), (Vec3)laserEmitter.getBlockPos().getCenter(), (Vec3)laserEmitter.end, (Color)new Color(color), (float)0.25f, (float)0.3f);
            poseStack.popPose();
        }
    }

    public AABB getRenderBoundingBox(LaserEmitterBlockEntity laserEmitter) {
        if (laserEmitter.end != null) {
            AABB bounds = AABB.encapsulatingFullBlocks((BlockPos)laserEmitter.getBlockPos(), (BlockPos)BlockPos.containing((Position)laserEmitter.end));
            return bounds;
        }
        return super.getRenderBoundingBox((BlockEntity)laserEmitter);
    }

    public LaserEmitterRenderer(BlockEntityRendererProvider.Context rendererProvider) {
        this.renderDispatcher = rendererProvider.getEntityRenderer();
    }
}

