/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.renderers.block;

import com.cmdpro.datanessence.block.technical.StructureProtectorBlockEntity;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;

public class StructureProtectorRenderer
implements BlockEntityRenderer<StructureProtectorBlockEntity> {
    EntityRenderDispatcher renderDispatcher;

    public StructureProtectorRenderer(BlockEntityRendererProvider.Context rendererProvider) {
        this.renderDispatcher = rendererProvider.getEntityRenderer();
    }

    public void render(StructureProtectorBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (Minecraft.getInstance().player.canUseGameMasterBlocks()) {
            BlockPos corner1 = blockEntity.getCorner1();
            BlockPos corner2 = blockEntity.getCorner2();
            BlockPos center = blockEntity.getBlockPos();
            Color color = Color.GREEN;
            Color centerColor = Color.WHITE;
            boolean complete = true;
            if (corner1 == null) {
                color = Color.RED;
                centerColor = Color.YELLOW;
                complete = false;
            } else if (corner2 == null) {
                corner2 = corner1;
                color = Color.RED;
                centerColor = Color.YELLOW;
                complete = false;
            }
            Vec3 renderOffset = blockEntity.getBlockPos().getCenter().subtract(0.5, 0.5, 0.5).scale(-1.0);
            VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.lines());
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            if (corner1 != null && corner2 != null) {
                BlockPos minBlock = new BlockPos(Math.min(corner1.getX(), corner2.getX()), Math.min(corner1.getY(), corner2.getY()), Math.min(corner1.getZ(), corner2.getZ()));
                BlockPos maxBlock = new BlockPos(Math.max(corner1.getX(), corner2.getX()), Math.max(corner1.getY(), corner2.getY()), Math.max(corner1.getZ(), corner2.getZ()));
                Vec3 min = minBlock.getCenter().add(-0.5, -0.5, -0.5).add(renderOffset);
                Vec3 max = maxBlock.getCenter().add(0.5, 0.5, 0.5).add(renderOffset);
                LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexconsumer, (double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z, (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f, (float)((float)color.getRed() / 255.0f / 2.0f), (float)((float)color.getGreen() / 255.0f / 2.0f), (float)((float)color.getBlue() / 255.0f / 2.0f));
            }
            if (!complete) {
                Vec3 centerMin = center.getCenter().add(-0.5, -0.5, -0.5).add(renderOffset);
                Vec3 centerMax = center.getCenter().add(0.5, 0.5, 0.5).add(renderOffset);
                LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexconsumer, (double)centerMin.x, (double)centerMin.y, (double)centerMin.z, (double)centerMax.x, (double)centerMax.y, (double)centerMax.z, (float)((float)centerColor.getRed() / 255.0f), (float)((float)centerColor.getGreen() / 255.0f), (float)((float)centerColor.getBlue() / 255.0f), (float)1.0f, (float)((float)centerColor.getRed() / 255.0f / 2.0f), (float)((float)centerColor.getGreen() / 255.0f / 2.0f), (float)((float)centerColor.getBlue() / 255.0f / 2.0f));
            }
            if (bufferSource instanceof MultiBufferSource.BufferSource) {
                MultiBufferSource.BufferSource source = (MultiBufferSource.BufferSource)bufferSource;
                source.endBatch(RenderType.lines());
            }
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }
}

