/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.renderers.entity;

import com.cmdpro.databank.misc.RenderingUtil;
import com.cmdpro.datanessence.entity.AncientSentinelLaser;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class AncientSentinelLaserRenderer
extends EntityRenderer<AncientSentinelLaser> {
    static ResourceLocation BEAM_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/misc/white.png");

    public AncientSentinelLaserRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public ResourceLocation getTextureLocation(AncientSentinelLaser pEntity) {
        return null;
    }

    public boolean shouldRender(AncientSentinelLaser livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public void render(AncientSentinelLaser entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        if (entity.getEnd() != null) {
            float f = (float)entity.time + partialTick;
            Objects.requireNonNull(entity);
            float progress = Math.clamp(f / 10.0f, 0.0f, 1.0f);
            float scale = 1.0f - progress;
            poseStack.pushPose();
            double d0 = Mth.lerp((double)partialTick, (double)entity.xOld, (double)entity.getX());
            double d1 = Mth.lerp((double)partialTick, (double)entity.yOld, (double)entity.getY());
            double d2 = Mth.lerp((double)partialTick, (double)entity.zOld, (double)entity.getZ());
            Vec3 posOffset = new Vec3(d0, d1, d2).subtract(entity.position());
            Vec3 pos = entity.position().add(posOffset);
            poseStack.translate(-pos.x, -pos.y, -pos.z);
            AncientSentinelLaserRenderer.renderBeam(poseStack, bufferSource, false, entity.position(), entity.getEnd(), entity.level().getGameTime(), partialTick, 0.05f * scale);
            poseStack.popPose();
        }
    }

    public static void renderBeam(PoseStack poseStack, MultiBufferSource bufferSource, boolean pre, Vec3 from, Vec3 to, long gameTime, float partialTick, float radius) {
        Color color = AncientSentinelLaser.getColor(gameTime, 0.8f, 1.0f);
        RenderingUtil.renderAdvancedBeaconBeam((PoseStack)poseStack, (MultiBufferSource)bufferSource, (ResourceLocation)BEAM_LOCATION, (float)partialTick, (float)1.0f, (long)gameTime, (Vec3)from, (Vec3)to, (Color)color, (float)(pre ? 0.0f : radius), (float)(pre ? radius : 0.0f));
    }
}

