/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.renderers.entity;

import com.cmdpro.databank.model.DatabankModel;
import com.cmdpro.databank.model.DatabankModels;
import com.cmdpro.databank.model.ModelPose;
import com.cmdpro.databank.model.entity.DatabankEntityModel;
import com.cmdpro.databank.model.entity.DatabankLivingEntityModel;
import com.cmdpro.databank.model.entity.DatabankLivingEntityRenderer;
import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.client.renderers.entity.AncientSentinelLaserRenderer;
import com.cmdpro.datanessence.entity.AncientSentinel;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class AncientSentinelRenderer
extends DatabankLivingEntityRenderer<AncientSentinel> {
    public AncientSentinelRenderer(EntityRendererProvider.Context p_272933_) {
        super(p_272933_, (DatabankEntityModel)new Model(), 0.5f);
    }

    public ResourceLocation getTextureLocation(AncientSentinel pEntity) {
        return DataNEssence.locate("textures/entity/ancient_sentinel.png");
    }

    public boolean shouldRender(AncientSentinel livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public void render(AncientSentinel pEntity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render((LivingEntity)pEntity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        int shootTime = pEntity.laserTime;
        if (shootTime >= 0) {
            Vec3 end = this.getEnd(pEntity);
            float scale = Math.clamp(((float)shootTime + partialTick) / (float)pEntity.maxLaserTime, 0.0f, 1.0f);
            poseStack.pushPose();
            double d0 = Mth.lerp((double)partialTick, (double)pEntity.xOld, (double)pEntity.getX());
            double d1 = Mth.lerp((double)partialTick, (double)pEntity.yOld, (double)pEntity.getY());
            double d2 = Mth.lerp((double)partialTick, (double)pEntity.zOld, (double)pEntity.getZ());
            Vec3 posOffset = new Vec3(d0, d1, d2).subtract(pEntity.position());
            Vec3 pos = pEntity.position().add(posOffset);
            poseStack.translate(-pos.x, -pos.y, -pos.z);
            AncientSentinelLaserRenderer.renderBeam(poseStack, bufferSource, true, pEntity.getEyePosition(), end, pEntity.level().getGameTime(), partialTick, 0.1f * scale);
            poseStack.popPose();
        }
    }

    private HitResult getHit(AncientSentinel sentinel, double hitDistance, boolean hitFluids) {
        Vec3 vec3 = sentinel.getEyePosition();
        Vec3 vec31 = sentinel.getEyePosition().vectorTo(sentinel.laserTarget).normalize();
        Vec3 vec32 = vec3.add(vec31.x * hitDistance, vec31.y * hitDistance, vec31.z * hitDistance);
        return sentinel.level().clip(new ClipContext(vec3, vec32, ClipContext.Block.OUTLINE, hitFluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, (Entity)sentinel));
    }

    private Vec3 getEnd(AncientSentinel sentinel) {
        HitResult result = this.getHit(sentinel, 20.0, false);
        return result.getLocation();
    }

    public static class Model
    extends DatabankLivingEntityModel<AncientSentinel> {
        public DatabankModel model;

        public DatabankModel getModel() {
            if (this.model == null) {
                this.model = (DatabankModel)DatabankModels.models.get(DataNEssence.locate("ancient_sentinel"));
            }
            return this.model;
        }

        public ResourceLocation getTextureLocation() {
            return DataNEssence.locate("textures/entity/ancient_sentinel.png");
        }

        public void setupModelPose(AncientSentinel pEntity, float partialTick) {
            pEntity.animState.updateAnimDefinitions(this.getModel());
            this.animate(pEntity.animState);
            Vec2 rot = new Vec2(Mth.lerp((float)partialTick, (float)pEntity.xRotO, (float)pEntity.getXRot()), Mth.rotLerp((float)partialTick, (float)pEntity.yHeadRotO, (float)pEntity.yHeadRot));
            float bodyRot = Mth.rotLerp((float)partialTick, (float)pEntity.yBodyRotO, (float)pEntity.yBodyRot);
            ((ModelPose.ModelPosePart)this.modelPose.stringToPart.get((Object)"head")).rotation.x = rot.x * ((float)Math.PI / 180);
            ((ModelPose.ModelPosePart)this.modelPose.stringToPart.get((Object)"head")).rotation.y = (rot.y - bodyRot) * ((float)Math.PI / 180);
        }
    }
}

