/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.renderers.layer;

import com.cmdpro.databank.model.DatabankModel;
import com.cmdpro.databank.model.DatabankModels;
import com.cmdpro.databank.model.ModelPose;
import com.cmdpro.databank.model.entity.DatabankEntityModel;
import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.registry.AttachmentTypeRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class HornsLayer<T extends Player, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    public static final ResourceLocation hornsTexture = DataNEssence.locate("textures/entity/horns.png");
    private final HornsModel hornsModel = new HornsModel(this);

    public HornsLayer(RenderLayerParent<T, M> pRenderer, EntityModelSet pModelSet) {
        super(pRenderer);
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (pLivingEntity.hasData(AttachmentTypeRegistry.HAS_HORNS) && ((Boolean)pLivingEntity.getData(AttachmentTypeRegistry.HAS_HORNS)).booleanValue()) {
            pPoseStack.pushPose();
            this.hornsModel.setupPose((Player)pLivingEntity, pPartialTick, ((HumanoidModel)this.getParentModel()).head);
            pPoseStack.pushPose();
            this.hornsModel.render((Entity)pLivingEntity, pPartialTick, pPoseStack, pBuffer, pPackedLight, OverlayTexture.NO_OVERLAY, -1, new Vec3(1.0, 1.0, 1.0));
            pPoseStack.popPose();
            pPoseStack.popPose();
        }
    }

    public class HornsModel
    extends DatabankEntityModel<Player> {
        public DatabankModel model;

        public HornsModel(HornsLayer this$0) {
        }

        public RenderType getRenderType(Player obj) {
            return RenderType.armorCutoutNoCull((ResourceLocation)hornsTexture);
        }

        public ResourceLocation getTextureLocation() {
            return hornsTexture;
        }

        public void setupModelPose(Player player, float partialTick) {
            this.modelPose = this.getModel().createModelPose();
        }

        public void setupPose(Player player, float partialTick, ModelPart connectedTo) {
            this.setupModelPose(player, partialTick);
            ModelPose.ModelPosePart root = (ModelPose.ModelPosePart)this.modelPose.stringToPart.get("root");
            root.scale = new Vector3f(connectedTo.xScale, connectedTo.yScale, connectedTo.zScale);
            root.rotation = new Vector3f(-connectedTo.xRot + (float)Math.toRadians(180.0), -connectedTo.yRot, connectedTo.zRot);
            root.pos = new Vector3f(connectedTo.x, connectedTo.y, connectedTo.z);
        }

        public DatabankModel getModel() {
            if (this.model == null) {
                this.model = (DatabankModel)DatabankModels.models.get(DataNEssence.locate("horns"));
            }
            return this.model;
        }
    }
}

