/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.shaders;

import com.cmdpro.databank.mixin.client.BufferSourceMixin;
import com.cmdpro.databank.mixin.client.RenderBuffersMixin;
import com.cmdpro.databank.rendering.RenderHandler;
import com.cmdpro.databank.rendering.ShaderHelper;
import com.cmdpro.databank.shaders.PostShaderInstance;
import com.cmdpro.datanessence.DataNEssence;
import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import java.util.SequencedMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4fc;

@EventBusSubscriber(value={Dist.CLIENT}, modid="datanessence")
public class MachineOutputShader
extends PostShaderInstance {
    private static RenderTarget machineOutputTarget;
    static MultiBufferSource.BufferSource machineOutputBufferSource;

    public ResourceLocation getShaderLocation() {
        return DataNEssence.locate("shaders/post/hologram.json");
    }

    public void setUniforms(PostPass instance) {
        super.setUniforms(instance);
        instance.getEffect().setSampler("HologramSampler", () -> ((RenderTarget)MachineOutputShader.getMachineOutputTarget()).getColorTextureId());
    }

    public static RenderTarget getMachineOutputTarget() {
        if (machineOutputTarget == null) {
            machineOutputTarget = new MainTarget(Minecraft.getInstance().getMainRenderTarget().width, Minecraft.getInstance().getMainRenderTarget().height);
            machineOutputTarget.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return machineOutputTarget;
    }

    public static MultiBufferSource.BufferSource createMachineOutputBufferSource() {
        if (machineOutputBufferSource == null) {
            RenderBuffers renderBuffers = Minecraft.getInstance().renderBuffers();
            MultiBufferSource.BufferSource source = ShaderHelper.needsBufferWorkaround() ? ((RenderBuffersMixin)renderBuffers).getBufferSource() : renderBuffers.bufferSource();
            BufferSourceMixin mixin = (BufferSourceMixin)source;
            SequencedMap fixedBuffers = mixin.getFixedBuffers();
            ByteBufferBuilder sharedBuffer = mixin.getSharedBuffer();
            machineOutputBufferSource = MultiBufferSource.immediateWithBuffers((SequencedMap)fixedBuffers, (ByteBufferBuilder)sharedBuffer);
        }
        return machineOutputBufferSource;
    }

    public void beforeProcess() {
        super.beforeProcess();
        if (ShaderHelper.shouldUseAlternateRendering()) {
            RenderSystem.getModelViewStack().pushMatrix().set((Matrix4fc)RenderHandler.matrix4f);
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShaderFogStart((float)RenderHandler.fogStart);
            MachineOutputShader.doEffectRendering();
            FogRenderer.setupNoFog();
            RenderSystem.getModelViewStack().popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (!ShaderHelper.shouldUseAlternateRendering() && event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_WEATHER)) {
            MachineOutputShader.doEffectRendering();
        }
    }

    private static void doEffectRendering() {
        RenderSystem.depthMask((boolean)true);
        MachineOutputShader.getMachineOutputTarget().clear(Minecraft.ON_OSX);
        MachineOutputShader.getMachineOutputTarget().copyDepthFrom(Minecraft.getInstance().getMainRenderTarget());
        MachineOutputShader.getMachineOutputTarget().bindWrite(true);
        MachineOutputShader.createMachineOutputBufferSource().endBatch();
        Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
        RenderSystem.depthMask((boolean)false);
    }

    static {
        machineOutputBufferSource = null;
    }
}

