/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.commands;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.util.DataTabletUtil;
import com.cmdpro.datanessence.api.util.PlayerDataUtil;
import com.cmdpro.datanessence.data.datatablet.Entries;
import com.cmdpro.datanessence.data.datatablet.Entry;
import com.cmdpro.datanessence.networking.ModMessages;
import com.cmdpro.datanessence.networking.packet.s2c.DragonPartsSync;
import com.cmdpro.datanessence.networking.packet.s2c.OpenEntryEditor;
import com.cmdpro.datanessence.registry.AttachmentTypeRegistry;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashMap;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class DataNEssenceCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"datanessence").requires(source -> source.hasPermission(4))).then(Commands.literal((String)"entry").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"reset_all").executes(command -> DataNEssenceCommands.resetlearned((CommandContext<CommandSourceStack>)command)))).then(Commands.literal((String)"unlock_all").executes(command -> DataNEssenceCommands.unlockall((CommandContext<CommandSourceStack>)command)))).then(Commands.literal((String)"set").then(Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).suggests((stack, builder) -> SharedSuggestionProvider.suggest(Entries.entries.keySet().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder)).then(((RequiredArgumentBuilder)Commands.argument((String)"set", (ArgumentType)BoolArgumentType.bool()).executes(command -> DataNEssenceCommands.modifyEntries((CommandContext<CommandSourceStack>)command, false))).then(Commands.argument((String)"completion_stage", (ArgumentType)IntegerArgumentType.integer()).executes(command -> DataNEssenceCommands.modifyEntries((CommandContext<CommandSourceStack>)command, true))))))))).then(Commands.literal((String)"set_tier").then(Commands.argument((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(command -> DataNEssenceCommands.settier((CommandContext<CommandSourceStack>)command))))).then(Commands.literal((String)"check_entry_overlaps").executes(command -> DataNEssenceCommands.checkoverlaps((CommandContext<CommandSourceStack>)command)))).then(Commands.literal((String)"give_dragon_part").then(Commands.argument((String)"part", (ArgumentType)StringArgumentType.string()).suggests((stack, builder) -> SharedSuggestionProvider.suggest((String[])new String[]{"horns", "tail", "wings", "all"}, (SuggestionsBuilder)builder)).executes(command -> DataNEssenceCommands.givedragonpart((CommandContext<CommandSourceStack>)command))))).then(Commands.literal((String)"maximize").executes(command -> DataNEssenceCommands.maximize((CommandContext<CommandSourceStack>)command)))).then(Commands.literal((String)"dev").then(Commands.literal((String)"entry_editor").executes(command -> DataNEssenceCommands.entryeditor((CommandContext<CommandSourceStack>)command)))));
    }

    private static int entryeditor(CommandContext<CommandSourceStack> command) {
        Entity entity = ((CommandSourceStack)command.getSource()).getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ModMessages.sendToPlayer(new OpenEntryEditor(), player);
        }
        return 1;
    }

    private static int checkoverlaps(CommandContext<CommandSourceStack> command) {
        boolean foundIssues = false;
        for (Entry i : Entries.entries.values()) {
            for (Entry o : Entries.entries.values()) {
                if (i == o || i.x != o.x || i.y != o.y || !i.tab.equals((Object)o.tab)) continue;
                foundIssues = true;
                if (((CommandSourceStack)command.getSource()).isPlayer()) {
                    ((CommandSourceStack)command.getSource()).getEntity().sendSystemMessage((Component)Component.translatable((String)"commands.datanessence.check_entry_overlaps.found", (Object[])new Object[]{i.id.toString(), o.id.toString()}));
                    continue;
                }
                DataNEssence.LOGGER.warn("Entry \"" + i.id.toString() + "\" is overlapping with entry \"" + o.id.toString() + "\"");
            }
        }
        if (!foundIssues) {
            ((CommandSourceStack)command.getSource()).getEntity().sendSystemMessage((Component)Component.translatable((String)"commands.datanessence.check_entry_overlaps.no_found"));
        }
        return 1;
    }

    private static int givedragonpart(CommandContext<CommandSourceStack> command) {
        if (((CommandSourceStack)command.getSource()).getEntity() instanceof Player) {
            ServerPlayer player;
            try {
                player = ((EntitySelector)command.getArgument("target", EntitySelector.class)).findSinglePlayer((CommandSourceStack)command.getSource());
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
            String part = (String)command.getArgument("part", String.class);
            if (part.equals("horns")) {
                player.setData(AttachmentTypeRegistry.HAS_HORNS, (Object)true);
            } else if (part.equals("tail")) {
                player.setData(AttachmentTypeRegistry.HAS_TAIL, (Object)true);
            } else if (part.equals("wings")) {
                player.setData(AttachmentTypeRegistry.HAS_WINGS, (Object)true);
            } else if (part.equals("all")) {
                player.setData(AttachmentTypeRegistry.HAS_HORNS, (Object)true);
                player.setData(AttachmentTypeRegistry.HAS_TAIL, (Object)true);
                player.setData(AttachmentTypeRegistry.HAS_WINGS, (Object)true);
            }
            ModMessages.sendToPlayersTrackingEntityAndSelf(new DragonPartsSync(player.getId(), (Boolean)player.getData(AttachmentTypeRegistry.HAS_HORNS), (Boolean)player.getData(AttachmentTypeRegistry.HAS_TAIL), (Boolean)player.getData(AttachmentTypeRegistry.HAS_WINGS)), player);
            ((CommandSourceStack)command.getSource()).sendSuccess(() -> DataNEssenceCommands.lambda$givedragonpart$12(part, (Player)player), true);
        }
        return 1;
    }

    private static int settier(CommandContext<CommandSourceStack> command) {
        if (((CommandSourceStack)command.getSource()).getEntity() instanceof Player) {
            Player player = (Player)((CommandSourceStack)command.getSource()).getEntity();
            int tier = (Integer)command.getArgument("tier", Integer.TYPE);
            DataTabletUtil.setTier(player, tier);
            ((CommandSourceStack)command.getSource()).sendSuccess(() -> Component.translatable((String)"commands.datanessence.set_tier", (Object[])new Object[]{tier, player.getName()}), true);
        }
        return 1;
    }

    private static int resetlearned(CommandContext<CommandSourceStack> command) {
        if (((CommandSourceStack)command.getSource()).getEntity() instanceof Player) {
            ServerPlayer player;
            try {
                player = ((EntitySelector)command.getArgument("target", EntitySelector.class)).findSinglePlayer((CommandSourceStack)command.getSource());
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
            List unlockedEntries = (List)player.getData(AttachmentTypeRegistry.UNLOCKED);
            unlockedEntries.clear();
            HashMap incompleteEntries = (HashMap)player.getData(AttachmentTypeRegistry.INCOMPLETE_STAGES);
            incompleteEntries.clear();
            HashMap unlockedEssences = (HashMap)player.getData(AttachmentTypeRegistry.UNLOCKED_ESSENCES);
            unlockedEssences.clear();
            PlayerDataUtil.updateUnlockedEntries(player);
            PlayerDataUtil.updateData(player);
            player.setData(AttachmentTypeRegistry.TIER, (Object)0);
            PlayerDataUtil.sendTier(player, false);
            ((CommandSourceStack)command.getSource()).sendSuccess(() -> DataNEssenceCommands.lambda$resetlearned$14((Player)player), true);
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int modifyEntries(CommandContext<CommandSourceStack> command, boolean hasAllArgs) {
        int completionStage;
        ServerPlayer player;
        if (!(((CommandSourceStack)command.getSource()).getEntity() instanceof Player)) return 1;
        try {
            player = ((EntitySelector)command.getArgument("target", EntitySelector.class)).findSinglePlayer((CommandSourceStack)command.getSource());
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        ResourceLocation entry = (ResourceLocation)command.getArgument("id", ResourceLocation.class);
        if (!Entries.entries.containsKey(entry)) {
            ((CommandSourceStack)command.getSource()).sendFailure((Component)Component.translatable((String)"commands.datanessence.entry.entry_doesnt_exist", (Object[])new Object[]{entry.toString()}));
            return 0;
        }
        boolean set = (Boolean)command.getArgument("set", Boolean.class);
        Entry entry2 = Entries.entries.get(entry);
        int n = completionStage = hasAllArgs ? ((Integer)command.getArgument("completion_stage", Integer.class)).intValue() : entry2.completionStages.size();
        if (entry2.completionStages.size() < completionStage) {
            ((CommandSourceStack)command.getSource()).sendFailure((Component)Component.translatable((String)"commands.datanessence.entry.entry_not_enough_stages", (Object[])new Object[]{entry.toString(), completionStage}));
            return 0;
        }
        List unlockedEntries = (List)player.getData(AttachmentTypeRegistry.UNLOCKED);
        if (set) {
            if (!unlockedEntries.contains(entry)) {
                DataTabletUtil.unlockEntryAndParents((Player)player, entry, completionStage);
                ((CommandSourceStack)command.getSource()).sendSuccess(() -> DataNEssenceCommands.lambda$modifyEntries$15(entry, (Player)player), true);
                return 1;
            }
            ((CommandSourceStack)command.getSource()).sendFailure((Component)Component.translatable((String)"commands.datanessence.entry.entry_already_unlocked", (Object[])new Object[]{entry.toString(), player.getName()}));
            return 0;
        }
        if (unlockedEntries.contains(entry)) {
            DataTabletUtil.removeEntry((Player)player, entry);
            ((CommandSourceStack)command.getSource()).sendSuccess(() -> DataNEssenceCommands.lambda$modifyEntries$16(entry, (Player)player), true);
            return 1;
        }
        ((CommandSourceStack)command.getSource()).sendFailure((Component)Component.translatable((String)"commands.datanessence.entry.entry_not_learned_in_the_first_place", (Object[])new Object[]{entry.toString(), player.getName()}));
        return 0;
    }

    private static int unlockall(CommandContext<CommandSourceStack> command) {
        if (((CommandSourceStack)command.getSource()).getEntity() instanceof Player) {
            Player player = (Player)((CommandSourceStack)command.getSource()).getEntity();
            List unlocked = (List)player.getData(AttachmentTypeRegistry.UNLOCKED);
            HashMap incompleteEntries = (HashMap)player.getData(AttachmentTypeRegistry.INCOMPLETE_STAGES);
            incompleteEntries.clear();
            unlocked.clear();
            unlocked.addAll(Entries.entries.values().stream().map(i -> i.id).toList());
            PlayerDataUtil.updateUnlockedEntries((ServerPlayer)player);
            DataTabletUtil.checkForTierUpgrades(player);
            ((CommandSourceStack)command.getSource()).sendSuccess(() -> Component.translatable((String)"commands.datanessence.unlock_all", (Object[])new Object[]{player.getName()}), true);
        }
        return 1;
    }

    private static int maximize(CommandContext<CommandSourceStack> command) {
        if (((CommandSourceStack)command.getSource()).getEntity() instanceof Player) {
            Player player = (Player)((CommandSourceStack)command.getSource()).getEntity();
            ((CommandSourceStack)command.getSource()).sendSuccess(() -> Component.translatable((String)"commands.datanessence.maximize", (Object[])new Object[]{player.getName()}), true);
            DataTabletUtil.setTier(player, 8);
            ((CommandSourceStack)command.getSource()).sendSuccess(() -> Component.translatable((String)"commands.datanessence.set_tier", (Object[])new Object[]{8, player.getName()}), true);
            for (Entry entry : Entries.entries.values()) {
                DataTabletUtil.unlockEntryAndParents(player, entry.id, entry.completionStages.size());
            }
            ((CommandSourceStack)command.getSource()).sendSuccess(() -> Component.translatable((String)"commands.datanessence.unlock_all", (Object[])new Object[]{player.getName()}), true);
            player.setData(AttachmentTypeRegistry.HAS_HORNS, (Object)true);
            player.setData(AttachmentTypeRegistry.HAS_TAIL, (Object)true);
            player.setData(AttachmentTypeRegistry.HAS_WINGS, (Object)true);
            ModMessages.sendToPlayersTrackingEntityAndSelf(new DragonPartsSync(player.getId(), (Boolean)player.getData(AttachmentTypeRegistry.HAS_HORNS), (Boolean)player.getData(AttachmentTypeRegistry.HAS_TAIL), (Boolean)player.getData(AttachmentTypeRegistry.HAS_WINGS)), (ServerPlayer)player);
            ((CommandSourceStack)command.getSource()).sendSuccess(() -> Component.translatable((String)"commands.datanessence.give_all_dragon_parts", (Object[])new Object[]{player.getName()}), true);
        }
        return 1;
    }

    private static /* synthetic */ Component lambda$modifyEntries$16(ResourceLocation entry, Player player) {
        return Component.translatable((String)"commands.datanessence.entry.remove_entry", (Object[])new Object[]{entry.toString(), player.getName()});
    }

    private static /* synthetic */ Component lambda$modifyEntries$15(ResourceLocation entry, Player player) {
        return Component.translatable((String)"commands.datanessence.entry.unlock_entry", (Object[])new Object[]{entry.toString(), player.getName()});
    }

    private static /* synthetic */ Component lambda$resetlearned$14(Player player) {
        return Component.translatable((String)"commands.datanessence.reset_learned", (Object[])new Object[]{player.getName()});
    }

    private static /* synthetic */ Component lambda$givedragonpart$12(String part, Player player) {
        return part.equals("all") ? Component.translatable((String)"commands.datanessence.give_all_dragon_parts", (Object[])new Object[]{player.getName()}) : Component.translatable((String)"commands.datanessence.give_dragon_part", (Object[])new Object[]{part, player.getName()});
    }
}

