/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.databank;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.data.databank.DataBankTypeSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class DataBankTypeManager
extends SimpleJsonResourceReloadListener {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static DataBankTypeManager instance;
    public static Map<ResourceLocation, ResourceLocation[]> types;
    public static DataBankTypeSerializer serializer;

    protected DataBankTypeManager() {
        super(GSON, "datanessence/data_tablet/data_bank_types");
    }

    public static DataBankTypeManager getOrCreateInstance() {
        if (instance == null) {
            instance = new DataBankTypeManager();
        }
        return instance;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        types = new HashMap<ResourceLocation, ResourceLocation[]>();
        HashMap<ResourceLocation, ResourceLocation[]> removals = new HashMap<ResourceLocation, ResourceLocation[]>();
        DataNEssence.LOGGER.info("[DATANESSENCE] Adding Data Bank Types");
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            ResourceLocation location = entry.getKey();
            if (location.getPath().startsWith("_")) continue;
            try {
                JsonObject obj = entry.getValue().getAsJsonObject();
                ResourceLocation[] ids = serializer.read(entry.getKey(), obj);
                ArrayList<ResourceLocation> idsList = new ArrayList<ResourceLocation>(List.of(ids));
                if (types.containsKey(entry.getKey())) {
                    idsList.addAll(List.of(types.get(entry.getKey())));
                }
                types.put(entry.getKey(), idsList.toArray(new ResourceLocation[0]));
                ArrayList<ResourceLocation> removals2 = new ArrayList<ResourceLocation>(List.of(serializer.readRemovals(entry.getKey(), obj)));
                if (!removals2.isEmpty()) {
                    removals2.addAll(List.of(removals.getOrDefault(entry.getKey(), new ResourceLocation[0])));
                    removals.put(entry.getKey(), removals2.toArray(new ResourceLocation[0]));
                }
                DataNEssence.LOGGER.info("[DATANESSENCE] Successfully added entry {}", (Object)location);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                DataNEssence.LOGGER.error("[DATANESSENCE] Parsing error loading data bank type {}", (Object)location, (Object)e);
            }
        }
        for (Map.Entry<Object, Object> entry : removals.entrySet()) {
            ResourceLocation[] ids = (ResourceLocation[])entry.getValue();
            ArrayList<ResourceLocation> idsList = new ArrayList<ResourceLocation>(List.of(types.get(entry.getKey())));
            idsList.removeAll(List.of(ids));
            types.put((ResourceLocation)entry.getKey(), idsList.toArray(new ResourceLocation[0]));
        }
        DataNEssence.LOGGER.info("[DATANESSENCE] Loaded {} Data Bank Types", (Object)types.size());
    }

    static {
        serializer = new DataBankTypeSerializer();
    }
}

