/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.databank;

import com.cmdpro.datanessence.data.databank.DataBankEntries;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class DataBankTypeSerializer {
    public ResourceLocation[] read(ResourceLocation entryId, JsonObject json) {
        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
        if (json.has("add")) {
            for (JsonElement i : json.getAsJsonArray("add")) {
                if (i.isJsonObject()) {
                    boolean required;
                    ResourceLocation value = ResourceLocation.tryParse((String)i.getAsJsonObject().get("value").getAsString());
                    boolean bl = required = i.getAsJsonObject().has("required") ? i.getAsJsonObject().get("required").getAsBoolean() : false;
                    if (!required) {
                        if (!DataBankEntries.entries.containsKey(value)) continue;
                        ids.add(value);
                        continue;
                    }
                    ids.add(value);
                    continue;
                }
                ids.add(ResourceLocation.tryParse((String)i.getAsString()));
            }
        }
        return ids.toArray(new ResourceLocation[0]);
    }

    public ResourceLocation[] readRemovals(ResourceLocation entryId, JsonObject json) {
        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
        if (json.has("remove")) {
            for (JsonElement i : json.getAsJsonArray("remove")) {
                ids.add(ResourceLocation.tryParse((String)i.getAsString()));
            }
        }
        return ids.toArray(new ResourceLocation[0]);
    }

    @Nonnull
    public static ResourceLocation[] fromNetwork(FriendlyByteBuf buf) {
        ResourceLocation[] ids = buf.readList(FriendlyByteBuf::readResourceLocation).toArray(new ResourceLocation[0]);
        return ids;
    }

    public static void toNetwork(FriendlyByteBuf buf, ResourceLocation[] ids) {
        buf.writeCollection(Arrays.stream(ids).toList(), FriendlyByteBuf::writeResourceLocation);
    }
}

