/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.datatablet;

import com.cmdpro.datanessence.data.datatablet.DataTab;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;

public class DataTabSerializer {
    public static final StreamCodec<RegistryFriendlyByteBuf, DataTab> STREAM_CODEC = StreamCodec.of((pBuffer, pValue) -> {
        pBuffer.writeResourceLocation(pValue.id);
        ItemStack.STREAM_CODEC.encode(pBuffer, (Object)pValue.icon);
        ComponentSerialization.STREAM_CODEC.encode(pBuffer, (Object)pValue.name);
        pBuffer.writeBoolean(pValue.alwaysShown);
        DataTab.DataTabPlacement.STREAM_CODEC.encode(pBuffer, (Object)pValue.placement);
    }, pBuffer -> {
        ResourceLocation id = pBuffer.readResourceLocation();
        ItemStack icon = (ItemStack)ItemStack.STREAM_CODEC.decode(pBuffer);
        Component name = (Component)ComponentSerialization.STREAM_CODEC.decode(pBuffer);
        boolean alwaysShown = pBuffer.readBoolean();
        DataTab.DataTabPlacement placement = (DataTab.DataTabPlacement)DataTab.DataTabPlacement.STREAM_CODEC.decode(pBuffer);
        DataTab entry = new DataTab(id, icon, name, alwaysShown, placement);
        return entry;
    });
    public static final MapCodec<DataTab> ORIGINAL_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("icon").forGetter(entry -> entry.icon), (App)ComponentSerialization.CODEC.fieldOf("name").forGetter(entry -> entry.name), (App)Codec.BOOL.optionalFieldOf("always_shown", (Object)false).forGetter(entry -> entry.alwaysShown), (App)DataTab.DataTabPlacement.CODEC.fieldOf("placement").forGetter(entry -> entry.placement)).apply((Applicative)instance, (icon, name, alwaysShown, placement) -> new DataTab(null, (ItemStack)icon, (Component)name, (boolean)alwaysShown, (DataTab.DataTabPlacement)placement)));
    public static final Codec<Optional<WithConditions<DataTab>>> CODEC = ConditionalOps.createConditionalCodecWithConditions((Codec)ORIGINAL_CODEC.codec());

    public DataTab read(ResourceLocation entryId, JsonObject json) {
        DataTab entry = ICondition.getWithWithConditionsCodec(CODEC, (DynamicOps)JsonOps.INSTANCE, (Object)json).orElse(null);
        if (entry != null) {
            entry.id = entryId;
            return entry;
        }
        return null;
    }
}

