/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.datatablet.pages;

import com.cmdpro.datanessence.api.datatablet.PageSerializer;
import com.cmdpro.datanessence.data.datatablet.pages.TextPage;
import com.cmdpro.datanessence.data.datatablet.pages.serializers.ItemPageSerializer;
import com.cmdpro.datanessence.screen.DataTabletScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;

public class ItemListPage
extends TextPage {
    public ItemStack[] items;
    public List<FormattedCharSequence> tooltipToShow = new ArrayList<FormattedCharSequence>();
    public boolean showTooltip;

    public ItemListPage(Component text, boolean rtl, ItemStack[] items) {
        super(text, rtl);
        this.items = items;
    }

    @Override
    public void render(DataTabletScreen screen, GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY, int xOffset, int yOffset) {
        super.render(screen, graphics, pPartialTick, pMouseX, pMouseY, xOffset, yOffset);
        for (ItemStack stack : this.items) {
            graphics.blit(DataTabletScreen.TEXTURE_MISC, xOffset + (DataTabletScreen.imageWidth / 2 - 19), yOffset + 4, 0, 0, 38, 38);
            this.renderItemWithTooltip(graphics, stack, xOffset + (DataTabletScreen.imageWidth / 2 - 19) + 11, yOffset + 15, pMouseX, pMouseY);
        }
    }

    @Override
    public void renderPost(DataTabletScreen screen, GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY, int xOffset, int yOffset) {
        super.renderPost(screen, pGuiGraphics, pPartialTick, pMouseX, pMouseY, xOffset, yOffset);
        if (this.showTooltip) {
            this.showTooltip = false;
            pGuiGraphics.renderTooltip(Minecraft.getInstance().font, this.tooltipToShow, pMouseX, pMouseY);
        }
    }

    @Override
    public int textYOffset() {
        return 44;
    }

    public void renderItemWithTooltip(GuiGraphics graphics, ItemStack item, int x, int y, int mouseX, int mouseY) {
        graphics.renderItem(item, x, y);
        graphics.renderItemDecorations(Minecraft.getInstance().font, item, x, y);
        if (mouseX >= x && mouseY >= y && mouseX <= x + 16 && mouseY <= y + 16) {
            this.showTooltip = true;
            this.tooltipToShow.clear();
            for (Component i : Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)item)) {
                this.tooltipToShow.add(i.getVisualOrderText());
            }
        }
    }

    @Override
    public PageSerializer getSerializer() {
        return ItemPageSerializer.INSTANCE;
    }
}

