/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.datatablet.pages;

import com.cmdpro.databank.multiblock.Multiblock;
import com.cmdpro.databank.multiblock.MultiblockManager;
import com.cmdpro.databank.multiblock.MultiblockRenderer;
import com.cmdpro.datanessence.api.datatablet.Page;
import com.cmdpro.datanessence.api.datatablet.PageSerializer;
import com.cmdpro.datanessence.data.datatablet.pages.serializers.MultiblockPageSerializer;
import com.cmdpro.datanessence.screen.DataTabletScreen;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.Rotation;

public class MultiblockPage
extends Page {
    public ResourceLocation multiblock;
    float renderRotationX;
    float renderRotationY;
    int mode;

    public MultiblockPage(ResourceLocation multiblock) {
        this.multiblock = multiblock;
        this.renderRotationX = -30.0f;
        this.renderRotationY = -45.0f;
        this.mode = 0;
    }

    @Override
    public void render(DataTabletScreen screen, GuiGraphics graphics, float partialTicks, int mouseX, int mouseY, int xOffset, int yOffset) {
        Multiblock multiblock = (Multiblock)MultiblockManager.multiblocks.get(this.multiblock);
        if (this.mode == 0) {
            this.renderMultiblock(graphics, multiblock, xOffset, yOffset);
        }
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 200.0f);
        if (mouseX >= xOffset + 120 && mouseX <= xOffset + 120 + 16 && mouseY >= yOffset + 142 && mouseY <= yOffset + 142 + 16) {
            graphics.blit(DataTabletScreen.TEXTURE_MISC, xOffset + 120, yOffset + 142, 0, 54, 16, 16);
        } else {
            graphics.blit(DataTabletScreen.TEXTURE_MISC, xOffset + 120, yOffset + 142, 0, 38, 16, 16);
        }
        graphics.pose().popPose();
    }

    public void renderMultiblock(GuiGraphics graphics, Multiblock multiblock, int xOffset, int yOffset) {
        graphics.pose().pushPose();
        int sizeX = multiblock.multiblockLayers[0][0].length();
        int sizeY = multiblock.multiblockLayers.length;
        int sizeZ = multiblock.multiblockLayers[0].length;
        float maxX = 90.0f;
        float maxY = 90.0f;
        float diag = (float)Math.sqrt(sizeX * sizeX + sizeZ * sizeZ);
        float scaleX = maxX / diag;
        float scaleY = maxY / (float)sizeY;
        float scale = -Math.min(scaleX, scaleY);
        graphics.pose().translate((float)xOffset + (float)DataTabletScreen.imageWidth / 2.0f, (float)yOffset + (float)DataTabletScreen.imageHeight / 2.0f, 100.0f);
        graphics.pose().scale(scale, scale, scale);
        graphics.pose().translate(-((float)sizeX) / 2.0f, -((float)sizeY) / 2.0f, 0.0f);
        float offX = (float)(-sizeX) / 2.0f;
        float offZ = (float)(-sizeZ) / 2.0f;
        graphics.pose().mulPose(Axis.XP.rotationDegrees(this.renderRotationX));
        graphics.pose().translate(-offX, 0.0f, -offZ);
        graphics.pose().mulPose(Axis.YP.rotationDegrees(this.renderRotationY));
        graphics.pose().translate(offX, 0.0f, offZ);
        graphics.pose().translate((float)(-multiblock.center.getX()), (float)(-multiblock.center.getY()), (float)(-multiblock.center.getZ()));
        MultiblockRenderer.renderMultiblock((Multiblock)multiblock, null, (PoseStack)graphics.pose(), (DeltaTracker)Minecraft.getInstance().getTimer(), (Rotation)Rotation.NONE, (MultiBufferSource.BufferSource)Minecraft.getInstance().renderBuffers().bufferSource());
        graphics.pose().popPose();
    }

    @Override
    public boolean onClick(DataTabletScreen screen, double pMouseX, double pMouseY, int pButton, int xOffset, int yOffset) {
        if (pMouseX >= (double)(xOffset + 120) && pMouseX <= (double)(xOffset + 120 + 16) && pMouseY >= (double)(yOffset + 142) && pMouseY <= (double)(yOffset + 142 + 16)) {
            MultiblockRenderer.multiblockPos = null;
            MultiblockRenderer.multiblockRotation = null;
            MultiblockRenderer.multiblock = MultiblockRenderer.multiblock == null ? (Multiblock)MultiblockManager.multiblocks.get(this.multiblock) : null;
            Client.playClick();
            Minecraft.getInstance().popGuiLayer();
            return true;
        }
        return super.onClick(screen, pMouseX, pMouseY, pButton, xOffset, yOffset);
    }

    @Override
    public boolean onDrag(DataTabletScreen screen, double mouseX, double mouseY, int button, double xDrag, double yDrag) {
        this.renderRotationX -= (float)(0.5 * yDrag);
        this.renderRotationY += (float)(0.5 * xDrag);
        return true;
    }

    @Override
    public PageSerializer getSerializer() {
        return MultiblockPageSerializer.INSTANCE;
    }

    public static class Client {
        public static void playClick() {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
    }
}

