/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.minigames;

import com.cmdpro.datanessence.api.databank.Minigame;
import com.cmdpro.datanessence.api.databank.MinigameCreator;
import com.cmdpro.datanessence.api.databank.MinigameSerializer;
import com.cmdpro.datanessence.data.minigames.ColorMixingMinigame;
import com.cmdpro.datanessence.registry.MinigameRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Color;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class ColorMixingMinigameCreator
extends MinigameCreator {
    public List<ColorMixingMinigameSerializer.ColorManipulation> manipulations;
    public Color startColor;
    public int maxManipulations;
    public int colorLevels;

    public ColorMixingMinigameCreator(List<ColorMixingMinigameSerializer.ColorManipulation> manipulations, Color startColor, int maxManipulations, int colorLevels) {
        this.manipulations = manipulations;
        this.startColor = startColor;
        this.maxManipulations = maxManipulations;
        this.colorLevels = colorLevels;
    }

    @Override
    public Minigame createMinigame() {
        return new ColorMixingMinigame(this.manipulations, this.startColor, this.maxManipulations, this.colorLevels);
    }

    @Override
    public MinigameSerializer getSerializer() {
        return MinigameRegistry.COLOR_MIXING.get();
    }

    public static class ColorMixingMinigameSerializer
    extends MinigameSerializer<ColorMixingMinigameCreator> {
        public static final Codec<ColorManipulation> COLOR_MANIPULATION_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("maxIntensity").forGetter(colorManipulation -> colorManipulation.maxIntensity), (App)Codec.INT.fieldOf("intensity").forGetter(colorManipulation -> colorManipulation.intensity), (App)Codec.INT.listOf().comapFlatMap(integer -> Util.fixedSize((List)integer, (int)3).map(integers -> new Color((Integer)integers.get(0), (Integer)integers.get(1), (Integer)integers.get(2))), color -> List.of(Integer.valueOf(color.getRed()), Integer.valueOf(color.getGreen()), Integer.valueOf(color.getBlue()))).fieldOf("color").forGetter(colorManipulation -> colorManipulation.color)).apply((Applicative)instance, ColorManipulation::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ColorManipulation> COLOR_MANIPULATION_STREAM_CODEC = StreamCodec.of((pBuffer, pValue) -> {
            pBuffer.writeInt(pValue.maxIntensity);
            pBuffer.writeInt(pValue.intensity);
            pBuffer.writeInt(pValue.color.getRed());
            pBuffer.writeInt(pValue.color.getGreen());
            pBuffer.writeInt(pValue.color.getBlue());
        }, pBuffer -> {
            int maxIntensity = pBuffer.readInt();
            int intensity = pBuffer.readInt();
            int R = pBuffer.readInt();
            int G = pBuffer.readInt();
            int B = pBuffer.readInt();
            Color color = new Color(R, G, B);
            return new ColorManipulation(maxIntensity, intensity, color);
        });
        public static final StreamCodec<RegistryFriendlyByteBuf, ColorMixingMinigameCreator> STREAM_CODEC = StreamCodec.of((pBuffer, pValue) -> {
            pBuffer.writeCollection(pValue.manipulations, (buf, value) -> COLOR_MANIPULATION_STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)buf), value));
            pBuffer.writeInt(pValue.startColor.getRed());
            pBuffer.writeInt(pValue.startColor.getGreen());
            pBuffer.writeInt(pValue.startColor.getBlue());
            pBuffer.writeInt(pValue.maxManipulations);
            pBuffer.writeInt(pValue.colorLevels);
        }, pBuffer -> {
            List manipulations = pBuffer.readList(buf -> (ColorManipulation)COLOR_MANIPULATION_STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)buf)));
            int startR = pBuffer.readInt();
            int startG = pBuffer.readInt();
            int startB = pBuffer.readInt();
            Color startColor = new Color(startR, startG, startB);
            int maxManipulations = pBuffer.readInt();
            int colorLevels = pBuffer.readInt();
            return new ColorMixingMinigameCreator(manipulations, startColor, maxManipulations, colorLevels);
        });
        public static final MapCodec<ColorMixingMinigameCreator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)COLOR_MANIPULATION_CODEC.listOf().fieldOf("colorManipulations").forGetter(minigame -> minigame.manipulations), (App)Codec.INT.listOf().comapFlatMap(integer -> Util.fixedSize((List)integer, (int)3).map(integers -> new Color((Integer)integers.get(0), (Integer)integers.get(1), (Integer)integers.get(2))), color -> List.of(Integer.valueOf(color.getRed()), Integer.valueOf(color.getGreen()), Integer.valueOf(color.getBlue()))).fieldOf("startColor").forGetter(minigame -> minigame.startColor), (App)Codec.INT.fieldOf("maxManipulations").forGetter(minigame -> minigame.maxManipulations), (App)Codec.INT.fieldOf("colorLevels").forGetter(minigame -> minigame.colorLevels)).apply((Applicative)instance, ColorMixingMinigameCreator::new));

        @Override
        public MapCodec<ColorMixingMinigameCreator> getCodec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ColorMixingMinigameCreator> getStreamCodec() {
            return STREAM_CODEC;
        }

        public static class ColorManipulation {
            public int maxIntensity;
            public int intensity;
            public Color color;

            public ColorManipulation(int maxIntensity, int intensity, Color color) {
                this.maxIntensity = maxIntensity;
                this.intensity = intensity;
                this.color = color;
            }

            public float getIntensity() {
                return (float)this.intensity / (float)this.maxIntensity;
            }
        }
    }
}

