/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.minigames;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.CommonVariables;
import com.cmdpro.datanessence.api.databank.Minigame;
import com.cmdpro.datanessence.registry.SoundRegistry;
import com.cmdpro.datanessence.screen.DataBankScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.apache.commons.lang3.RandomUtils;
import org.joml.Vector2i;

public class MinesweeperMinigame
extends Minigame {
    public static final ResourceLocation TEXTURE = DataNEssence.locate("textures/gui/data_bank_minigames.png");
    public int bombCount;
    public int size;
    public List<Vector2i> bombs;
    public HashMap<Vector2i, Tile> tiles;
    public int gameOver = -1;

    public MinesweeperMinigame(int bombCount, int size) {
        this.bombCount = bombCount;
        this.size = size;
        this.randomizeBombs(bombCount);
    }

    public void randomizeBombs(int bombCount) {
        ArrayList<Vector2i> noBombPos = new ArrayList<Vector2i>();
        noBombPos.add(new Vector2i(6, 6));
        noBombPos.add(new Vector2i(6, 7));
        noBombPos.add(new Vector2i(6, 8));
        noBombPos.add(new Vector2i(7, 6));
        noBombPos.add(new Vector2i(7, 7));
        noBombPos.add(new Vector2i(7, 8));
        noBombPos.add(new Vector2i(8, 6));
        noBombPos.add(new Vector2i(8, 7));
        noBombPos.add(new Vector2i(8, 8));
        ArrayList<Vector2i> bombs = new ArrayList<Vector2i>();
        for (int i = 0; i < bombCount; ++i) {
            Vector2i pos = new Vector2i(RandomUtils.nextInt((int)(7 - this.size), (int)(7 + this.size)), RandomUtils.nextInt((int)(7 - this.size), (int)(7 + this.size)));
            while (bombs.contains(pos) || noBombPos.contains(pos)) {
                pos = new Vector2i(RandomUtils.nextInt((int)(7 - this.size), (int)(7 + this.size)), RandomUtils.nextInt((int)(7 - this.size), (int)(7 + this.size)));
            }
            bombs.add(pos);
        }
        this.setBombs(bombs);
        this.revealSegment(new Vector2i(7, 7), null);
    }

    @Override
    public boolean isFinished() {
        if (this.tiles == null || this.bombs == null) {
            return false;
        }
        boolean finished = true;
        for (Tile i : this.tiles.values()) {
            if (i.cleared || i.isBomb) continue;
            finished = false;
            break;
        }
        return finished;
    }

    public void setBombs(List<Vector2i> bombs) {
        this.bombs = bombs;
        this.tiles = new HashMap();
        for (int i = 0; i < 15; ++i) {
            for (int o = 0; o < 15; ++o) {
                Vector2i pos;
                Tile tile = new Tile(this);
                tile.pos = pos = new Vector2i(i, o);
                if (i < 7 - this.size || o < 7 - this.size || i > 7 + this.size || o > 7 + this.size) {
                    tile.nearbyBombs = 0;
                    tile.cleared = true;
                    tile.isBomb = false;
                } else {
                    tile.isBomb = bombs.contains(pos);
                    int nearbyBombs = 0;
                    for (int i2 = -1; i2 <= 1; ++i2) {
                        for (int o2 = -1; o2 <= 1; ++o2) {
                            Vector2i pos2 = new Vector2i(i + i2, o + o2);
                            if (!bombs.contains(pos2)) continue;
                            ++nearbyBombs;
                        }
                    }
                    tile.nearbyBombs = nearbyBombs;
                }
                this.tiles.put(pos, tile);
            }
        }
    }

    public void revealSegment(Vector2i start, Tile last) {
        if (last != null && last.nearbyBombs > 0) {
            return;
        }
        Tile tile = this.getTile(start);
        if (tile == null || tile.cleared || tile.isBomb) {
            return;
        }
        tile.cleared = true;
        for (int i = -1; i <= 1; ++i) {
            for (int o = -1; o <= 1; ++o) {
                if (i == 0 && o == 0) continue;
                this.revealSegment(new Vector2i(start.x + i, start.y + o), tile);
            }
        }
    }

    public Tile getTile(Vector2i pos) {
        return this.tiles.get(pos);
    }

    @Override
    public void render(DataBankScreen screen, GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY, int x, int y) {
        for (Tile i : this.tiles.values()) {
            if (!i.cleared) {
                if (pMouseX >= x + i.pos.x * 10 && pMouseY >= y + i.pos.y * 10 && pMouseX <= x + i.pos.x * 10 + 9 && pMouseY <= y + i.pos.y * 10 + 9) {
                    pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10, y + i.pos.y * 10, 11, i.isMarked ? 11 : 0, 10, 10);
                    continue;
                }
                pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10, y + i.pos.y * 10, 0, i.isMarked ? 11 : 0, 10, 10);
                continue;
            }
            if (i.isBomb) {
                pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10, y + i.pos.y * 10, 33, 0, 10, 10);
                continue;
            }
            pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10, y + i.pos.y * 10, 22, 0, 10, 10);
            if (i.nearbyBombs <= 0) continue;
            pGuiGraphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.literal((String)String.valueOf(i.nearbyBombs)).withStyle(Style.EMPTY.withFont(CommonVariables.ANCIENT_FONT)), x + i.pos.x * 10 + 5, y + i.pos.y * 10 + 1, -1);
        }
        if (this.gameOver >= 0) {
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().translate(0.0f, 0.0f, 399.0f);
            pGuiGraphics.fill(x, y, x + 150, y + (int)(75.0f * ((float)this.gameOver / 50.0f)), -16777216);
            pGuiGraphics.fill(x, y + 150 - (int)(75.0f * ((float)this.gameOver / 50.0f)), x + 150, y + 150, -16777216);
            pGuiGraphics.pose().popPose();
        }
    }

    @Override
    public void tick() {
        if (this.gameOver >= 0) {
            ++this.gameOver;
            if (this.gameOver >= 50) {
                this.gameOver = -1;
                this.randomizeBombs(this.bombCount);
            }
        }
    }

    @Override
    public void mouseClicked(double pMouseX, double pMouseY, int pButton) {
        super.mouseClicked(pMouseX, pMouseY, pButton);
        if (this.gameOver == -1) {
            for (Tile i : this.tiles.values()) {
                if (i.cleared || !(pMouseX >= (double)(i.pos.x * 10)) || !(pMouseY >= (double)(i.pos.y * 10)) || !(pMouseX <= (double)(i.pos.x * 10 + 9)) || !(pMouseY <= (double)(i.pos.y * 10 + 9))) continue;
                if (pButton == 0) {
                    i.cleared = true;
                    i.isMarked = false;
                    Client.breakTile();
                    if (!i.isBomb) break;
                    Client.explode();
                    this.gameOver = 0;
                    break;
                }
                if (!i.isMarked) {
                    Client.placeFlag();
                } else {
                    Client.removeFlag();
                }
                i.isMarked = !i.isMarked;
                break;
            }
        }
    }

    @Override
    public String getLocalizationKey() {
        return "data_tablet.databank_minigame_minesweeper";
    }

    public class Tile {
        public boolean cleared;
        public Vector2i pos;
        public int nearbyBombs;
        public boolean isBomb;
        public boolean isMarked;

        public Tile(MinesweeperMinigame this$0) {
        }
    }

    public class Client {
        public Client(MinesweeperMinigame this$0) {
        }

        public static void placeFlag() {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.MINESWEEPER_PLACE_FLAG.value()), (float)1.0f, (float)1.0f));
        }

        public static void removeFlag() {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.MINESWEEPER_REMOVE_FLAG.value()), (float)1.0f, (float)1.0f));
        }

        public static void breakTile() {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.MINESWEEPER_BREAK.value()), (float)1.0f, (float)1.0f));
        }

        public static void explode() {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.MINESWEEPER_EXPLODE.value()), (float)1.0f, (float)1.0f));
        }
    }
}

