/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.minigames;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.databank.Minigame;
import com.cmdpro.datanessence.screen.DataBankScreen;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import org.joml.Vector2d;
import org.joml.Vector2i;

public class TracesMinigame
extends Minigame {
    public static final ResourceLocation TEXTURE = DataNEssence.locate("textures/gui/data_bank_minigames.png");
    public HashMap<Vector2i, Tile> tiles;
    public int size;
    private int time;
    public Vector2i start;
    public List<Vector2i> path = new ArrayList<Vector2i>();
    public Vector2i current;
    public int pathColor;
    public int pathEssence;

    public TracesMinigame(Map<Vector2i, Tile> tiles, int size) {
        this.size = size;
        this.setupTiles();
        this.tiles.putAll(tiles);
    }

    public void setupTiles() {
        this.tiles = new HashMap();
        for (int i = -this.size; i <= this.size; ++i) {
            for (int o = -this.size; o <= this.size; ++o) {
                Vector2i pos;
                Tile tile = new Tile();
                tile.pos = pos = new Vector2i(7 + i, 7 + o);
                this.tiles.put(pos, tile);
            }
        }
    }

    @Override
    public boolean isFinished() {
        boolean finished = true;
        ArrayList unfilledTiles = new ArrayList(this.tiles.keySet().stream().toList());
        for (Map.Entry<Vector2i, Tile> i : this.tiles.entrySet()) {
            if (i.getValue().type == 1 || i.getValue().type == 2) {
                unfilledTiles.remove(i.getKey());
            }
            if (i.getValue().type != 1) continue;
            for (Vector2i j : i.getValue().path) {
                unfilledTiles.remove(j);
            }
            if (this.isConnectedToEnd(i.getValue())) continue;
            finished = false;
            break;
        }
        if (!unfilledTiles.isEmpty()) {
            return false;
        }
        return finished;
    }

    public boolean isConnectedToEnd(Tile tile) {
        if (tile.type == 1) {
            if (tile.path.isEmpty()) {
                return false;
            }
            Tile tile2 = this.getTile(tile.path.getLast());
            if (tile2 != null) {
                return tile2.type == 2;
            }
        } else {
            return true;
        }
        return false;
    }

    public Tile getTile(Vector2i pos) {
        return this.tiles.get(pos);
    }

    public Tile getTile(Vector2d pos) {
        return this.tiles.get(new Vector2i((int)Math.floor(pos.x / 10.0), (int)Math.floor(pos.y / 10.0)));
    }

    @Override
    public void tick() {
        super.tick();
        ++this.time;
    }

    @Override
    public void render(DataBankScreen screen, GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY, int x, int y) {
        boolean allConnectedToEnds = true;
        ArrayList<Vector2i> pathedTiles = new ArrayList<Vector2i>();
        for (Tile i : this.tiles.values()) {
            if (i.type == 1 && !this.isConnectedToEnd(i)) {
                allConnectedToEnds = false;
            }
            if (i.type != 1) continue;
            pathedTiles.addAll(i.path);
        }
        for (Tile i : this.tiles.values()) {
            if (i.type == 0) {
                if (pMouseX >= x + i.pos.x * 10 && pMouseY >= y + i.pos.y * 10 && pMouseX <= x + i.pos.x * 10 + 9 && pMouseY <= y + i.pos.y * 10 + 9) {
                    pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10, y + i.pos.y * 10, 33, 11, 10, 10);
                } else {
                    pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10, y + i.pos.y * 10, 22, 11, 10, 10);
                }
                if (!allConnectedToEnds || pathedTiles.contains(i.pos)) continue;
                float[] originalColor = (float[])RenderSystem.getShaderColor().clone();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - ((float)Math.sin(Math.toRadians(((float)this.time + pPartialTick) * 4.0f)) / 2.0f + 1.0f) / 2.0f));
                RenderSystem.enableBlend();
                pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10 + 4, y + i.pos.y * 10 + 2, 44, 0, 2, 6);
                RenderSystem.setShaderColor((float)originalColor[0], (float)originalColor[1], (float)originalColor[2], (float)originalColor[3]);
                RenderSystem.disableBlend();
                continue;
            }
            if (i.type == 1) {
                if (pMouseX >= x + i.pos.x * 10 && pMouseY >= y + i.pos.y * 10 && pMouseX <= x + i.pos.x * 10 + 9 && pMouseY <= y + i.pos.y * 10 + 9) {
                    pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10, y + i.pos.y * 10, 11, 22 + i.essence * 11, 10, 10);
                    continue;
                }
                pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10, y + i.pos.y * 10, 0, 22 + i.essence * 11, 10, 10);
                continue;
            }
            if (i.type == 2) {
                if (pMouseX >= x + i.pos.x * 10 && pMouseY >= y + i.pos.y * 10 && pMouseX <= x + i.pos.x * 10 + 9 && pMouseY <= y + i.pos.y * 10 + 9) {
                    pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10, y + i.pos.y * 10, 33, 22 + i.essence * 11, 10, 10);
                    continue;
                }
                pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10, y + i.pos.y * 10, 22, 22 + i.essence * 11, 10, 10);
                continue;
            }
            if (i.type != 3) continue;
            if (pMouseX >= x + i.pos.x * 10 && pMouseY >= y + i.pos.y * 10 && pMouseX <= x + i.pos.x * 10 + 9 && pMouseY <= y + i.pos.y * 10 + 9) {
                pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10, y + i.pos.y * 10, 55, 22 + i.essence * 11, 10, 10);
                continue;
            }
            pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10, y + i.pos.y * 10, 44, 22 + i.essence * 11, 10, 10);
        }
        for (Tile i : this.tiles.values()) {
            if (i.path.isEmpty()) continue;
            Vector2i last = null;
            for (Vector2i j : i.path) {
                if (last == null) {
                    last = j;
                    continue;
                }
                int color = 0;
                if (i.essence == 0) {
                    color = -1952017;
                }
                if (i.essence == 1) {
                    color = -656448;
                }
                if (i.essence == 2) {
                    color = -11013268;
                }
                if (i.essence == 3) {
                    color = -1573639;
                }
                this.drawLine(new Vector2d((double)x + (double)last.x * 10.0 + 6.0, (double)y + (double)last.y * 10.0 + 6.0), new Vector2d((double)x + (double)j.x * 10.0 + 6.0, (double)y + (double)j.y * 10.0 + 6.0), color);
                last = j;
            }
        }
        if (!this.path.isEmpty()) {
            int color = this.pathColor;
            ArrayList<Vector2i> pathSoFar = new ArrayList<Vector2i>();
            for (Vector2i j : this.path) {
                for (Map.Entry<Vector2i, Tile> k : this.tiles.entrySet()) {
                    if (k.getKey().equals((Object)this.start) || !k.getValue().path.contains(j) && (!k.getKey().equals((Object)j) || k.getValue().type != 1)) continue;
                    color = 0xFF0000;
                }
                if (pathSoFar.contains(j)) {
                    color = 0xFF0000;
                }
                pathSoFar.add(j);
            }
            Tile endTile = this.getTile((Vector2i)pathSoFar.getLast());
            if (endTile.type == 2 && endTile.essence != this.pathEssence) {
                color = 0xFF0000;
            }
            Vector2i last = null;
            for (Vector2i j : this.path) {
                if (last == null) {
                    last = j;
                    continue;
                }
                this.drawLine(new Vector2d((double)x + (double)last.x * 10.0 + 6.0, (double)y + (double)last.y * 10.0 + 6.0), new Vector2d((double)x + (double)j.x * 10.0 + 6.0, (double)y + (double)j.y * 10.0 + 6.0), color);
                last = j;
            }
        }
    }

    @Override
    public void mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        if (pButton == 0) {
            for (Tile i : this.tiles.values()) {
                if (!(pMouseX >= (double)(i.pos.x * 10)) || !(pMouseY >= (double)(i.pos.y * 10)) || !(pMouseX <= (double)(i.pos.x * 10 + 9)) || !(pMouseY <= (double)(i.pos.y * 10 + 9))) continue;
                if (this.current == i.pos) break;
                if (!this.path.contains(i.pos)) {
                    if (this.current == null || !i.pos.equals(this.current.x + 1, this.current.y) && !i.pos.equals(this.current.x - 1, this.current.y) && !i.pos.equals(this.current.x, this.current.y + 1) && !i.pos.equals(this.current.x, this.current.y - 1) || this.getTile((Vector2i)this.path.getLast()).type == 2 || this.path.contains(i.pos)) break;
                    this.path.addLast(i.pos);
                    this.current = i.pos;
                    break;
                }
                if (this.path.size() < 2 || !this.path.get(this.path.size() - 2).equals((Object)i.pos)) break;
                this.path.removeLast();
                this.current = i.pos;
                break;
            }
        }
    }

    @Override
    public void mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            boolean valid = true;
            for (Tile tile : this.tiles.values()) {
                if (!(pMouseX >= (double)(tile.pos.x * 10)) || !(pMouseY >= (double)(tile.pos.y * 10)) || !(pMouseX <= (double)(tile.pos.x * 10 + 9)) || !(pMouseY <= (double)(tile.pos.y * 10 + 9)) || tile.type == 2) continue;
                valid = false;
            }
            if (valid && !this.path.isEmpty()) {
                ArrayList<Vector2i> pathSoFar = new ArrayList<Vector2i>();
                for (Vector2i j : this.path) {
                    for (Map.Entry<Vector2i, Tile> k : this.tiles.entrySet()) {
                        if (k.getKey().equals((Object)this.start) || !k.getValue().path.contains(j) && (!k.getKey().equals((Object)j) || k.getValue().type != 1)) continue;
                        valid = false;
                    }
                    if (pathSoFar.contains(j)) {
                        valid = false;
                    }
                    pathSoFar.add(j);
                }
                Tile tile = this.getTile((Vector2i)pathSoFar.getLast());
                if (tile.type == 2 && tile.essence != this.pathEssence) {
                    valid = false;
                }
                if (valid) {
                    this.tiles.get((Object)this.start).path = new ArrayList<Vector2i>(this.path);
                }
            }
            this.path.clear();
            this.start = null;
            this.current = null;
        }
    }

    public void drawLine(Vector2d start, Vector2d end, int color) {
        GlStateManager._depthMask((boolean)false);
        GlStateManager._disableCull();
        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        Tesselator tess = RenderSystem.renderThreadTesselator();
        RenderSystem.lineWidth((float)(2.0f * (float)Minecraft.getInstance().getWindow().getGuiScale()));
        BufferBuilder buf = tess.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        Vec2 vec = new Vec2((float)start.x - (float)end.x, (float)start.y - (float)end.y).normalized();
        buf.addVertex((float)start.x, (float)start.y, 0.0f).setColor(color).setNormal(vec.x, vec.y, 0.0f);
        buf.addVertex((float)end.x, (float)end.y, 0.0f).setColor(color).setNormal(vec.x, vec.y, 0.0f);
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        GlStateManager._enableCull();
        GlStateManager._depthMask((boolean)true);
        RenderSystem.lineWidth((float)1.0f);
    }

    @Override
    public void mouseClicked(double pMouseX, double pMouseY, int pButton) {
        super.mouseClicked(pMouseX, pMouseY, pButton);
        if (pButton == 0) {
            for (Tile i : this.tiles.values()) {
                if (!(pMouseX >= (double)(i.pos.x * 10)) || !(pMouseY >= (double)(i.pos.y * 10)) || !(pMouseX <= (double)(i.pos.x * 10 + 9)) || !(pMouseY <= (double)(i.pos.y * 10 + 9))) continue;
                if (i.type != 1) break;
                if (i.essence == 0) {
                    this.pathColor = -1952017;
                }
                if (i.essence == 1) {
                    this.pathColor = -656448;
                }
                if (i.essence == 2) {
                    this.pathColor = -11013268;
                }
                if (i.essence == 3) {
                    this.pathColor = -1573639;
                }
                this.pathEssence = i.essence;
                this.start = i.pos;
                i.path.clear();
                this.path.clear();
                this.path.add(this.start);
                this.current = this.start;
                break;
            }
        }
    }

    @Override
    public String getLocalizationKey() {
        return "data_tablet.databank_minigame_traces";
    }

    public static class Tile {
        public Vector2i pos;
        public int type;
        public int essence;
        public List<Vector2i> path = new ArrayList<Vector2i>();
    }

    public class Client {
        public Client(TracesMinigame this$0) {
        }
    }
}

