/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.pinging;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.data.pinging.PingableStructure;
import com.cmdpro.datanessence.data.pinging.PingableStructureSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class PingableStructureManager
extends SimpleJsonResourceReloadListener {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static PingableStructureManager instance;
    public static Map<ResourceLocation, PingableStructure> types;
    public static PingableStructureSerializer serializer;

    protected PingableStructureManager() {
        super(GSON, "datanessence/pingable_structures");
    }

    public static PingableStructureManager getOrCreateInstance() {
        if (instance == null) {
            instance = new PingableStructureManager();
        }
        return instance;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        types = new HashMap<ResourceLocation, PingableStructure>();
        DataNEssence.LOGGER.info("[DATANESSENCE] Adding Pingable Structures");
        for (Map.Entry<ResourceLocation, JsonElement> i : pObject.entrySet()) {
            ResourceLocation location = i.getKey();
            if (location.getPath().startsWith("_")) continue;
            try {
                JsonObject obj = i.getValue().getAsJsonObject();
                PingableStructure data = serializer.read(i.getKey(), obj);
                types.put(i.getKey(), data);
                DataNEssence.LOGGER.info("[DATANESSENCE] Successfully added pingable structure {}", (Object)location);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                DataNEssence.LOGGER.error("[DATANESSENCE ERROR] Parsing error loading pingable structure {}", (Object)location, (Object)e);
            }
        }
        DataNEssence.LOGGER.info("[DATANESSENCE] Loaded {} pingable structures", (Object)types.size());
    }

    static {
        types = new HashMap<ResourceLocation, PingableStructure>();
        serializer = new PingableStructureSerializer();
    }
}

