/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.datagen;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.registry.BlockRegistry;
import com.cmdpro.datanessence.registry.FluidRegistry;
import com.cmdpro.datanessence.registry.ItemRegistry;
import java.util.LinkedHashMap;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModItemModelProvider
extends ItemModelProvider {
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "datanessence", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(ItemRegistry.DATA_TABLET);
        this.simpleItem(ItemRegistry.DATA_DRIVE);
        this.simpleItem(ItemRegistry.COGNIZANT_CUBE);
        this.simpleItem(ItemRegistry.UNDER_THE_SKY_MUSIC_DISC);
        this.simpleItem(ItemRegistry.ESSENCE_SHARD);
        this.simpleItem(ItemRegistry.PRIMITIVE_ANTI_GRAVITY_PACK);
        this.simpleItem(ItemRegistry.TRAVERSITE_TRUDGERS);
        this.simpleItem(ItemRegistry.TRAVERSITE_ROAD_CHUNK);
        this.simpleItem(ItemRegistry.WARP_CAPSULE);
        this.simpleItem(ItemRegistry.THERMOMETER);
        this.simpleItem(ItemRegistry.MOLD_ROD);
        this.simpleItem(ItemRegistry.MOLD_PANEL);
        this.simpleItem(ItemRegistry.HAMMER_AND_CHISEL);
        this.simpleItem(ItemRegistry.LOCATOR);
        this.simpleItem(ItemRegistry.ESSENCE_METER);
        this.simpleItem(ItemRegistry.ORE_SCANNER);
        this.simpleItemWithSubdirectory(ItemRegistry.ESSENCE_WIRE, "wires");
        this.simpleItemWithSubdirectory(ItemRegistry.LUNAR_ESSENCE_WIRE, "wires");
        this.simpleItemWithSubdirectory(ItemRegistry.NATURAL_ESSENCE_WIRE, "wires");
        this.simpleItemWithSubdirectory(ItemRegistry.EXOTIC_ESSENCE_WIRE, "wires");
        this.simpleItemWithSubdirectory(ItemRegistry.ITEM_WIRE, "wires");
        this.simpleItemWithSubdirectory(ItemRegistry.FLUID_WIRE, "wires");
        this.simpleItemWithSubdirectory(ItemRegistry.CHEMICAL_WIRE, "wires");
        this.simpleItemWithSubdirectory(ItemRegistry.ACCELERATION_LENS, "lenses");
        this.simpleItemWithSubdirectory(ItemRegistry.BURNING_LENS, "lenses");
        this.simpleItemWithSubdirectory(ItemRegistry.HARMING_LENS, "lenses");
        this.simpleItemWithSubdirectory(ItemRegistry.HEALING_LENS, "lenses");
        this.simpleItemWithSubdirectory(ItemRegistry.PRECISION_LENS, "lenses");
        this.simpleItemWithSubdirectory(ItemRegistry.ATTRACTING_LENS, "lenses");
        this.simpleItemWithSubdirectory(ItemRegistry.SPRITE_BOOK_FLORA, "sprites");
        this.handheldItem(ItemRegistry.ESSENCE_REDIRECTOR);
        this.handheldItem(ItemRegistry.ESSENCE_SWORD);
        this.handheldItem(ItemRegistry.ILLUMINATION_ROD);
        this.evenSimplerBlockItem(BlockRegistry.ESSENCE_CRYSTAL);
        this.evenSimplerBlockItem(BlockRegistry.DECO_ESSENCE_BUFFER);
        this.evenSimplerBlockItem(BlockRegistry.DECO_ITEM_BUFFER);
        this.evenSimplerBlockItem(BlockRegistry.DECO_FLUID_BUFFER);
        this.evenSimplerBlockItem(BlockRegistry.ANCIENT_ROCK_COLUMN);
        this.evenSimplerBlockItem(BlockRegistry.ANCIENT_ROCK_BRICKS);
        this.evenSimplerBlockItem(BlockRegistry.ANCIENT_ROCK_TILES);
        this.evenSimplerBlockItem(BlockRegistry.ENERGIZED_ANCIENT_ROCK_COLUMN);
        this.evenSimplerBlockItem(BlockRegistry.ANCIENT_LANTERN);
        this.evenSimplerBlockItem(BlockRegistry.SPIRE_GLASS);
        this.evenSimplerBlockItem(BlockRegistry.CRYSTALLINE_LEAVES);
        this.evenSimplerBlockItem(BlockRegistry.CRYSTALLINE_LOG);
        this.evenSimplerBlockItem(BlockRegistry.POLISHED_OBSIDIAN_COLUMN);
        this.evenSimplerBlockItem(BlockRegistry.POLISHED_OBSIDIAN_TRACT);
        this.evenSimplerBlockItem(BlockRegistry.TRAVERSITE_ROAD_STAIRS);
        this.evenSimplerBlockItem(BlockRegistry.TRAVERSITE_ROAD_SLAB);
        this.evenSimplerBlockItem(BlockRegistry.TRAVERSITE_ROAD_STAIRS_OPAL);
        this.evenSimplerBlockItem(BlockRegistry.TRAVERSITE_ROAD_SLAB_OPAL);
        this.simpleItemWithSubdirectory(ItemRegistry.CONDUCTANCE_ROD, "components");
        this.simpleItemWithSubdirectory(ItemRegistry.CAPACITANCE_PANEL, "components");
        this.simpleItemWithSubdirectory(ItemRegistry.LOGICAL_MATRIX, "components");
        this.simpleItemWithSubdirectory(ItemRegistry.LENS, "components");
        this.simpleItemWithSubdirectory(ItemRegistry.PROPELLER, "components");
        this.simpleItemWithSubdirectory(ItemRegistry.WIRE_SPOOL, "components");
        this.simpleItemWithSubdirectory(ItemRegistry.IRON_DRILL, "components");
        this.simpleItemWithSubdirectory(ItemRegistry.EXCITER, "components");
        this.simpleItemWithSubdirectory(ItemRegistry.HEATING_COIL, "components");
        this.simpleItemWithSubdirectory(ItemRegistry.COPPER_SHELL, "components");
        this.simpleItemWithSubdirectory(ItemRegistry.ESSENCE_PATHWAYS, "components");
        this.simpleItemWithSubdirectory(ItemRegistry.ASSEMBLY_ACTUATOR, "components");
        this.simpleItemWithSubdirectory(ItemRegistry.COPPER_NUGGET, "intermediates");
        this.simpleItemWithSubdirectory(ItemRegistry.DIAMOND_SHARD, "intermediates");
        this.simpleItemWithSubdirectory(ItemRegistry.EMERALD_SHARD, "intermediates");
        this.simpleItemWithSubdirectory(ItemRegistry.COAL_LUMP, "intermediates");
        this.simpleItemWithSubdirectory(ItemRegistry.ESSENCE_BOMB, "bombs");
        this.simpleItemWithSubdirectory(ItemRegistry.LUNAR_ESSENCE_BOMB, "bombs");
        this.simpleItemWithSubdirectory(ItemRegistry.NATURAL_ESSENCE_BOMB, "bombs");
        this.simpleItemWithSubdirectory(ItemRegistry.EXOTIC_ESSENCE_BOMB, "bombs");
        this.simpleItemWithSubdirectory(ItemRegistry.SPEED_UPGRADE, "sigils");
        this.simpleItemWithSubdirectory(ItemRegistry.FILTER_UPGRADE, "sigils");
        this.simpleItem(ItemRegistry.LENSING_CRYSTAL);
        this.simpleItem(ItemRegistry.BONDING_POWDER);
        this.simpleItem(() -> FluidRegistry.GENDERFLUID.bucket.get());
        this.essencePoint(BlockRegistry.LUNAR_ESSENCE_POINT);
        this.essencePoint(BlockRegistry.NATURAL_ESSENCE_POINT);
        this.essencePoint(BlockRegistry.EXOTIC_ESSENCE_POINT);
        this.essencePoint(BlockRegistry.ITEM_POINT);
        this.essencePoint(BlockRegistry.FLUID_POINT);
        this.essencePoint(BlockRegistry.CHEMICAL_NODE);
        this.musicDiscPlayer(ItemRegistry.MUSIC_DISC_PLAYER);
        this.grapplingHook(ItemRegistry.GRAPPLING_HOOK);
        this.grapplingHook(ItemRegistry.TRANS_GRAPPLING_HOOK);
    }

    private ItemModelBuilder musicDiscPlayer(Supplier<Item> item) {
        ((ItemModelBuilder)this.withExistingParent("music_disc_player_on", ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"datanessence", (String)"item/music_disc_player_on"));
        return ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"datanessence", (String)"item/music_disc_player"))).override().predicate(DataNEssence.locate("playing"), 1.0f).model((ModelFile)this.getExistingFile(DataNEssence.locate("music_disc_player_on"))).end();
    }

    private ItemModelBuilder simpleItem(Supplier<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"datanessence", (String)("item/" + BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath())));
    }

    private ItemModelBuilder grapplingHook(Supplier<Item> item) {
        ItemModelBuilder using = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath() + "_use", ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"datanessence", (String)("item/" + BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath() + "_use")));
        ItemModelBuilder charged = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath() + "_charged", ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"datanessence", (String)("item/" + BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath())));
        ItemModelBuilder empty = ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"datanessence", (String)("item/" + BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath() + "_empty")))).override().predicate(DataNEssence.locate("charged"), 1.0f).predicate(DataNEssence.locate("using"), 0.0f).model((ModelFile)charged).end().override().predicate(DataNEssence.locate("charged"), 1.0f).predicate(DataNEssence.locate("using"), 1.0f).model((ModelFile)using).end();
        return empty;
    }

    private ItemModelBuilder simpleItemWithSubdirectory(Supplier<Item> item, String subdirectory) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"datanessence", (String)("item/" + subdirectory + "/" + BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath())));
    }

    private ItemModelBuilder flatBlockItemWithTexture(Supplier<Block> item, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)item.get()).getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", texture);
    }

    public void evenSimplerBlockItem(Supplier<Block> block) {
        this.withExistingParent("datanessence:" + BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath(), this.modLoc("block/" + BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath()));
    }

    public void essencePoint(Supplier<Block> item) {
        this.withExistingParent("datanessence:" + BuiltInRegistries.ITEM.getKey((Object)item.get().asItem()).getPath(), this.modLoc("item/essence_point"));
    }

    public void wallItem(Supplier<Block> block, Supplier<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", DataNEssence.locate("block/" + BuiltInRegistries.BLOCK.getKey((Object)baseBlock.get()).getPath()));
    }

    private ItemModelBuilder handheldItem(Supplier<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath(), ResourceLocation.withDefaultNamespace((String)"item/handheld"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"datanessence", (String)("item/" + BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath())));
    }

    private ItemModelBuilder simpleBlockItem(Supplier<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)item.get()).getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"datanessence", (String)("item/" + BuiltInRegistries.BLOCK.getKey((Object)item.get()).getPath())));
    }

    private ItemModelBuilder simpleBlockItemBlockTexture(Supplier<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)item.get()).getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"datanessence", (String)("block/" + BuiltInRegistries.BLOCK.getKey((Object)item.get()).getPath())));
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.IRON, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.COPPER, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.GOLD, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.EMERALD, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.LAPIS, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST, Float.valueOf(1.0f));
    }
}

