/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.entity;

import com.cmdpro.databank.model.animation.DatabankAnimationReference;
import com.cmdpro.databank.model.animation.DatabankAnimationState;
import com.cmdpro.databank.model.animation.DatabankEntityAnimationState;
import com.cmdpro.datanessence.entity.AncientSentinelLaser;
import com.cmdpro.datanessence.entity.AncientSentinelProjectile;
import com.cmdpro.datanessence.registry.EntityRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class AncientSentinel
extends Monster {
    public DatabankAnimationState animState = new DatabankEntityAnimationState("idle", (Entity)this).addAnim(new DatabankAnimationReference("idle", (state, anim) -> {}, (state, anim) -> {}));
    public static final EntityDataAccessor<Integer> LASER_TIME = SynchedEntityData.defineId(AncientSentinel.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Vector3f> LASER_TARGET = SynchedEntityData.defineId(AncientSentinel.class, (EntityDataSerializer)EntityDataSerializers.VECTOR3);
    public int laserTime = -1;
    public int maxLaserTime = -1;
    public Vec3 laserTarget;

    public AncientSentinel(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.animState.setLevel(level);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.ATTACK_SPEED, 0.0).add(Attributes.MOVEMENT_SPEED, 0.0).build();
    }

    public boolean isPercentDamage(Entity projectile, LivingEntity target) {
        OwnableEntity ownable;
        return target instanceof Player || target instanceof OwnableEntity && (ownable = (OwnableEntity)target).getOwner() != null && ownable.getOwner() instanceof Player;
    }

    public float getPercentDamage(Entity projectile, LivingEntity target) {
        if (projectile instanceof AncientSentinelProjectile) {
            return 0.125f;
        }
        if (projectile instanceof AncientSentinelLaser) {
            return 0.25f;
        }
        return 0.0f;
    }

    protected void setLevel(Level level) {
        super.setLevel(level);
        this.animState.setLevel(level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new SentinelAttackGoal(this, 1.0, 25, 50, 15.0f));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)SoundRegistry.ANCIENT_SENTINEL_WALK.value());
    }

    protected SoundEvent getAmbientSound() {
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)SoundRegistry.ANCIENT_SENTINEL_HURT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.ANCIENT_SENTINEL_DEATH.value();
    }

    protected float getSoundVolume() {
        return 0.2f;
    }

    public void checkDespawn() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard();
        }
    }

    public void performRangedAttack(LivingEntity pTarget, AttackType type) {
        if (type == AttackType.LASER) {
            this.laserTarget = pTarget.getEyePosition();
            this.laserTime = 20;
            this.getEntityData().set(LASER_TIME, (Object)this.laserTime, true);
            this.getEntityData().set(LASER_TARGET, (Object)this.laserTarget.toVector3f(), true);
        } else if (type == AttackType.SHOOT) {
            AncientSentinelProjectile projectile = new AncientSentinelProjectile(EntityRegistry.ANCIENT_SENTINEL_PROJECTILE.get(), (LivingEntity)this, this.level());
            double d0 = pTarget.getX() - this.getX();
            double d1 = pTarget.getEyeY() - (double)0.1f - projectile.getY();
            double d2 = pTarget.getZ() - this.getZ();
            Vec3 vec = new Vec3(d0, d1, d2).normalize();
            projectile.setDeltaMovement(vec.multiply(0.5, 0.5, 0.5));
            this.playSound((SoundEvent)SoundRegistry.ANCIENT_SENTINEL_SHOOT.value(), 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)projectile);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LASER_TIME, (Object)-1);
        builder.define(LASER_TARGET, (Object)new Vector3f());
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key == LASER_TIME) {
            this.laserTime = this.maxLaserTime = ((Integer)this.getEntityData().get(LASER_TIME)).intValue();
        }
        if (key == LASER_TARGET) {
            Vector3f vec = (Vector3f)this.getEntityData().get(LASER_TARGET);
            this.laserTarget = new Vec3((double)vec.x, (double)vec.y, (double)vec.z);
        }
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.laserTarget == null) {
            this.laserTime = -1;
        }
        if (this.laserTime >= 0) {
            --this.laserTime;
            this.lookAt(EntityAnchorArgument.Anchor.EYES, this.laserTarget);
            if (this.laserTime == 0) {
                AncientSentinelLaser laser = new AncientSentinelLaser(EntityRegistry.ANCIENT_SENTINEL_LASER.get(), (LivingEntity)this, this.level());
                laser.setDeltaMovement(this.getEyePosition().vectorTo(this.laserTarget).normalize());
                this.level().addFreshEntity((Entity)laser);
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && this.laserTime >= 0) {
            --this.laserTime;
            this.lookAt(EntityAnchorArgument.Anchor.EYES, this.laserTarget);
        }
    }

    public boolean canProgressInterval() {
        return this.laserTime < 0;
    }

    protected static class SentinelAttackGoal
    extends Goal {
        private final Mob mob;
        private final AncientSentinel ancientSentinel;
        @Nullable
        private LivingEntity target;
        private int attackTime = -1;
        private final double speedModifier;
        private int seeTime;
        private final int shootAttackInterval;
        private final int laserAttackInterval;
        private final float attackRadius;
        private AttackType currentType = AttackType.NONE;
        private static final float MAX_SHOOT_DISTANCE = 8.0f;

        public SentinelAttackGoal(AncientSentinel ancientSentinel, double speedModifier, int shootAttackInterval, int laserAttackInterval, float attackRadius) {
            if (ancientSentinel == null) {
                throw new IllegalArgumentException("SentinelAttackGoal requires Mob implements AncientSentinel");
            }
            this.ancientSentinel = ancientSentinel;
            this.mob = ancientSentinel;
            this.speedModifier = speedModifier;
            this.shootAttackInterval = shootAttackInterval;
            this.laserAttackInterval = laserAttackInterval;
            this.attackRadius = attackRadius;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity != null && livingentity.isAlive()) {
                this.target = livingentity;
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.canUse() || this.target.isAlive() && !this.mob.getNavigation().isDone();
        }

        public void stop() {
            this.target = null;
            this.seeTime = 0;
            this.attackTime = -1;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            if (this.target == null) {
                return;
            }
            double distance = this.mob.position().distanceTo(this.target.position());
            boolean canSee = this.mob.getSensing().hasLineOfSight((Entity)this.target);
            AttackType type = this.currentType;
            if (canSee) {
                ++this.seeTime;
                type = AttackType.SHOOT;
                type = distance <= 8.0 ? AttackType.SHOOT : AttackType.LASER;
            } else {
                this.seeTime = 0;
                type = AttackType.NONE;
            }
            if (type != this.currentType) {
                this.currentType = type;
            }
            if (!(distance > (double)this.attackRadius) && this.seeTime >= 5) {
                this.mob.getNavigation().stop();
            } else {
                this.mob.getNavigation().moveTo((Entity)this.target, this.speedModifier);
            }
            this.mob.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
            if (this.ancientSentinel.canProgressInterval()) {
                --this.attackTime;
            }
            if (this.attackTime == 0) {
                if (type == AttackType.NONE) {
                    return;
                }
                this.ancientSentinel.performRangedAttack(this.target, this.currentType);
                this.attackTime = type == AttackType.SHOOT ? this.shootAttackInterval : this.laserAttackInterval;
            } else if (this.attackTime < 0) {
                this.attackTime = type == AttackType.SHOOT ? this.shootAttackInterval : this.laserAttackInterval;
            }
        }
    }

    public static enum AttackType {
        NONE,
        SHOOT,
        LASER;

    }
}

