/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.entity;

import com.cmdpro.databank.misc.CollisionTestCube;
import com.cmdpro.datanessence.client.particle.CircleParticleOptions;
import com.cmdpro.datanessence.entity.AncientSentinel;
import com.cmdpro.datanessence.registry.DamageTypeRegistry;
import java.awt.Color;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class AncientSentinelLaser
extends Entity {
    public LivingEntity owner;
    public int time;
    public final int maxTime = 10;
    private boolean shot;
    private Vec3 end;

    public AncientSentinelLaser(EntityType<AncientSentinelLaser> entityType, Level world) {
        super(entityType, world);
    }

    protected AncientSentinelLaser(EntityType<AncientSentinelLaser> entityType, double x, double y, double z, Level world) {
        this(entityType, world);
        this.setPos(x, y, z);
    }

    public AncientSentinelLaser(EntityType<AncientSentinelLaser> entityType, LivingEntity shooter, Level world) {
        this(entityType, shooter.getX(), shooter.getEyeY(), shooter.getZ(), world);
        this.owner = shooter;
        this.setDeltaMovement(shooter.getLookAngle());
    }

    public void tick() {
        super.tick();
        HitResult hit = this.getHit(20.0, false);
        this.end = hit.getLocation();
        ++this.time;
        if (this.level().isClientSide) {
            if (!this.shot) {
                ClientMethods.particle(this.getRandom(), this.end, this.level());
                this.shot = true;
            }
        } else {
            if (!this.shot) {
                CollisionTestCube cube = new CollisionTestCube(AABB.ofSize((Vec3)this.position().lerp(this.end, 0.5), (double)0.5, (double)0.5, (double)(this.position().distanceTo(this.end) * 2.0)));
                Quaternionf rotation = new Quaternionf();
                Vec2 angle = AncientSentinelLaser.calculateRotationVector(this.position(), this.end);
                rotation.rotateY((float)Math.toRadians(-angle.y + 180.0f));
                rotation.rotateX((float)Math.toRadians(-angle.x));
                cube.rotation = rotation;
                cube.getEntitiesOfClass(LivingEntity.class, this.level()).forEach(i -> {
                    if (i != this.owner) {
                        float f;
                        AncientSentinel sentinel;
                        LivingEntity patt0$temp;
                        boolean isPercent;
                        DamageSource damagesource = null;
                        if (this.owner instanceof LivingEntity) {
                            damagesource = this.damageSources().source(DamageTypeRegistry.ancientProjectile, (Entity)this, (Entity)this.owner);
                            this.owner.setLastHurtMob((Entity)i);
                        }
                        boolean bl = isPercent = (patt0$temp = this.owner) instanceof AncientSentinel && (sentinel = (AncientSentinel)patt0$temp).isPercentDamage(this, (LivingEntity)i);
                        if (isPercent) {
                            LivingEntity patt0$temp2 = this.owner;
                            if (patt0$temp2 instanceof AncientSentinel) {
                                AncientSentinel sentinel2 = (AncientSentinel)patt0$temp2;
                                f = sentinel2.getPercentDamage(this, (LivingEntity)i);
                            } else {
                                f = 0.0f;
                            }
                        } else {
                            f = 0.0f;
                        }
                        float percent = f;
                        i.hurt(damagesource, isPercent ? i.getMaxHealth() * percent : 5.0f);
                    }
                });
                this.shot = true;
            }
            if (this.time >= 10) {
                this.remove(Entity.RemovalReason.KILLED);
            }
        }
    }

    private static Vec2 calculateRotationVector(Vec3 pVec, Vec3 pTarget) {
        double d0 = pTarget.x - pVec.x;
        double d1 = pTarget.y - pVec.y;
        double d2 = pTarget.z - pVec.z;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        return new Vec2(Mth.wrapDegrees((float)((float)(-(Mth.atan2((double)d1, (double)d3) * 57.2957763671875)))), Mth.wrapDegrees((float)((float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f)));
    }

    public Vec3 getEnd() {
        return this.end;
    }

    private HitResult getHit(double hitDistance, boolean hitFluids) {
        Vec3 vec3 = this.position();
        Vec3 vec31 = this.getDeltaMovement().normalize();
        Vec3 vec32 = vec3.add(vec31.x * hitDistance, vec31.y * hitDistance, vec31.z * hitDistance);
        return this.level().clip(new ClipContext(vec3, vec32, ClipContext.Block.OUTLINE, hitFluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, (Entity)this));
    }

    public boolean shouldBeSaved() {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }

    public static Color getColor(Level level) {
        return AncientSentinelLaser.getColor(level.getGameTime());
    }

    public static Color getColor(long gameTime) {
        return AncientSentinelLaser.getColor(gameTime, 1.0f, 1.0f);
    }

    public static Color getColor(long gameTime, float s, float b) {
        return Color.getHSBColor((float)(gameTime % 100L) / 100.0f, s, b);
    }

    private static class ClientMethods {
        private ClientMethods() {
        }

        public static void particle(RandomSource random, Vec3 pos, Level level) {
            for (int i = 0; i < 25; ++i) {
                Vec3 dir = new Vec3((double)Mth.nextFloat((RandomSource)random, (float)-1.0f, (float)1.0f), (double)Mth.nextFloat((RandomSource)random, (float)-1.0f, (float)1.0f), (double)Mth.nextFloat((RandomSource)random, (float)-1.0f, (float)1.0f)).normalize().multiply(0.25, 0.25, 0.25);
                level.addParticle((ParticleOptions)new CircleParticleOptions().setColor(AncientSentinelLaser.getColor(level)).setAdditive(true), pos.x, pos.y, pos.z, dir.x, dir.y, dir.z);
            }
        }
    }
}

