/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.entity;

import com.cmdpro.databank.misc.ColorGradient;
import com.cmdpro.databank.misc.TrailLeftoverHandler;
import com.cmdpro.databank.misc.TrailRender;
import com.cmdpro.databank.rendering.RenderHandler;
import com.cmdpro.databank.rendering.RenderTypeHandler;
import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.registry.DamageTypeRegistry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EssenceSlashProjectile
extends Projectile {
    public int time;
    public int rotation;
    Vec3 previousPos;
    private List<TrailRender> trails;

    public EssenceSlashProjectile(EntityType<EssenceSlashProjectile> entityType, Level world) {
        super(entityType, world);
        this.rotation = this.random.nextIntBetweenInclusive(-20, 20);
    }

    protected EssenceSlashProjectile(EntityType<EssenceSlashProjectile> entityType, double x, double y, double z, Level world) {
        this(entityType, world);
        this.setPos(x, y, z);
    }

    public EssenceSlashProjectile(EntityType<EssenceSlashProjectile> entityType, LivingEntity shooter, Level world) {
        this(entityType, shooter.getX(), shooter.getEyeY() - 0.5, shooter.getZ(), world);
        this.setOwner((Entity)shooter);
        this.setDeltaMovement(shooter.getLookAngle().multiply(0.5, 0.5, 0.5));
    }

    protected void onHitBlock(BlockHitResult hit) {
        this.remove(Entity.RemovalReason.KILLED);
        super.onHitBlock(hit);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("time", this.time);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.time = tag.getInt("time");
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 p_36758_, Vec3 p_36759_) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)p_36758_, (Vec3)p_36759_, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), x$0 -> this.canHitEntity((Entity)x$0));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }

    public void tick() {
        this.previousPos = this.position();
        this.setPos(this.getX() + this.getDeltaMovement().x, this.getY() + this.getDeltaMovement().y, this.getZ() + this.getDeltaMovement().z);
        if (!this.level().isClientSide) {
            HitResult hitresult;
            ++this.time;
            if (this.time >= 100) {
                this.remove(Entity.RemovalReason.KILLED);
            }
            if ((hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0))).getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.onHit(hitresult);
            }
            while (!this.isRemoved()) {
                EntityHitResult entityhitresult = this.findHitEntity(this.position(), this.position().add(this.getDeltaMovement()));
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.getType() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitresult).getEntity();
                    Entity entity1 = this.getOwner();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).canHarmPlayer((Player)entity)) {
                        hitresult = null;
                        entityhitresult = null;
                    }
                }
                if (hitresult != null && hitresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                    this.onHit(hitresult);
                    this.hasImpulse = true;
                }
                if (entityhitresult == null) break;
                hitresult = null;
            }
        }
        super.tick();
    }

    protected void onHitEntity(EntityHitResult hit) {
        Entity entity;
        boolean flag;
        DamageSource damagesource;
        super.onHitEntity(hit);
        Entity entity2 = this.getOwner();
        if (entity2 instanceof LivingEntity) {
            damagesource = this.damageSources().source(DamageTypeRegistry.magicProjectile, (Entity)this, entity2);
            ((LivingEntity)entity2).setLastHurtMob(hit.getEntity());
        } else if (entity2 instanceof Player) {
            damagesource = this.damageSources().source(DamageTypeRegistry.magicProjectile, (Entity)this, entity2);
            ((LivingEntity)entity2).setLastHurtMob(hit.getEntity());
        } else {
            damagesource = null;
        }
        boolean bl = flag = hit.getEntity().getType() == EntityType.ENDERMAN;
        if (damagesource != null && (entity = hit.getEntity()) instanceof LivingEntity) {
            LivingEntity ent = (LivingEntity)entity;
            if (entity2 instanceof LivingEntity && ent.hurt(damagesource, 5.0f) && flag) {
                return;
            }
        }
        this.remove(Entity.RemovalReason.KILLED);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClientRemoval() {
        super.onClientRemoval();
        if (this.trails != null) {
            for (TrailRender i : this.trails) {
                TrailLeftoverHandler.addTrail((TrailRender)i, (MultiBufferSource)RenderHandler.createBufferSource(), (int)0xF000F0, (ColorGradient)this.getGradient());
            }
        }
    }

    public ColorGradient getGradient() {
        return new ColorGradient(new Color(143, 0, 215), new Color(255, 255, 255)).fadeAlpha(1.0f, 0.0f).fadeAlpha(0.0f, 0.0f, 1.0f, 0.05f);
    }

    public TrailRender getTrail(int index) {
        return this.getTrails().get(index);
    }

    public List<TrailRender> getTrails() {
        if (this.trails == null) {
            this.trails = new ArrayList<TrailRender>();
            this.trails.add(new TrailRender(this.getTrailOffset(0), 20, 20, 0.05f, DataNEssence.locate("textures/vfx/trail.png"), RenderTypeHandler::transparent).setShrink(true).startTicking());
            this.trails.add(new TrailRender(this.getTrailOffset(1), 20, 20, 0.05f, DataNEssence.locate("textures/vfx/trail.png"), RenderTypeHandler::transparent).setShrink(true).startTicking());
        }
        return this.trails;
    }

    public Vec3 getTrailOffset(int index) {
        Vec2 rot = this.calculateRotationVector(new Vec3(0.0, 0.0, 0.0), this.getDeltaMovement());
        Quaternionf quaternionf = new Quaternionf();
        quaternionf.rotateY((-rot.y - 90.0f) * ((float)Math.PI / 180));
        quaternionf.rotateZ(-rot.x * ((float)Math.PI / 180));
        quaternionf.rotateX((float)this.rotation * ((float)Math.PI / 180));
        Vec3 pos = new Vec3(0.2, 0.0, 0.0);
        float dist = 0.3f;
        float speed = 16.0f;
        float timeRot = (float)this.level().getGameTime() % (360.0f * speed) * speed;
        timeRot %= 360.0f;
        timeRot += 180.0f;
        if (index % 2 == 0) {
            dist *= -1.0f;
        }
        float yShift = (float)Math.sin(Math.toRadians(timeRot));
        pos = pos.add((double)((1.0f - Math.abs(yShift)) * 0.4f), (double)(yShift * dist), 0.0);
        Vector3f posVec = pos.toVector3f().rotate((Quaternionfc)quaternionf);
        return new Vec3((double)posVec.x, (double)posVec.y, (double)posVec.z);
    }

    private Vec2 calculateRotationVector(Vec3 pVec, Vec3 pTarget) {
        double d0 = pTarget.x - pVec.x;
        double d1 = pTarget.y - pVec.y;
        double d2 = pTarget.z - pVec.z;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        return new Vec2(Mth.wrapDegrees((float)((float)(-(Mth.atan2((double)d1, (double)d3) * 57.2957763671875)))), Mth.wrapDegrees((float)((float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f)));
    }
}

