/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.entity;

import com.cmdpro.databank.misc.ColorGradient;
import com.cmdpro.datanessence.entity.ThrownTrailItemProjectile;
import com.cmdpro.datanessence.registry.EntityRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.registry.ItemRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class ThrownEssenceBombProjectile
extends ThrownTrailItemProjectile {
    public ThrownEssenceBombProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ThrownEssenceBombProjectile(LivingEntity pShooter, Level pLevel) {
        super(EntityRegistry.ESSENCE_BOMB.get(), pShooter, pLevel);
    }

    public ThrownEssenceBombProjectile(Level pLevel, double pX, double pY, double pZ) {
        super(EntityRegistry.ESSENCE_BOMB.get(), pX, pY, pZ, pLevel);
    }

    protected Item getDefaultItem() {
        return ItemRegistry.ESSENCE_BOMB.get();
    }

    protected void onHit(HitResult pResult) {
        super.onHit(pResult);
        if (!this.level().isClientSide) {
            this.level().explode((Entity)this, pResult.getLocation().x, pResult.getLocation().y, pResult.getLocation().z, 4.0f, Level.ExplosionInteraction.TNT);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    public ColorGradient getGradient() {
        return EssenceTypeRegistry.ESSENCE.get().getThrowGradient();
    }
}

