/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.entity;

import com.cmdpro.databank.misc.ColorGradient;
import com.cmdpro.databank.misc.TrailLeftoverHandler;
import com.cmdpro.databank.misc.TrailRender;
import com.cmdpro.databank.rendering.RenderHandler;
import com.cmdpro.databank.rendering.RenderTypeHandler;
import com.cmdpro.datanessence.DataNEssence;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class ThrownTrailItemProjectile
extends ThrowableItemProjectile {
    private TrailRender trail;

    public ThrownTrailItemProjectile(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownTrailItemProjectile(EntityType<? extends ThrowableItemProjectile> entityType, double x, double y, double z, Level level) {
        super(entityType, x, y, z, level);
    }

    public ThrownTrailItemProjectile(EntityType<? extends ThrowableItemProjectile> entityType, LivingEntity shooter, Level level) {
        super(entityType, shooter, level);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClientRemoval() {
        super.onClientRemoval();
        TrailRender render = this.getTrail();
        if (render != null) {
            TrailLeftoverHandler.addTrail((TrailRender)render, (MultiBufferSource)RenderHandler.createBufferSource(), (int)0xF000F0, (ColorGradient)this.getGradient());
        }
    }

    public ColorGradient getGradient() {
        return new ColorGradient(new Color(255, 255, 255), new Color(255, 255, 255)).fadeAlpha(1.0f, 0.0f).fadeAlpha(0.0f, 0.0f, 1.0f, 0.05f);
    }

    public TrailRender getTrail() {
        if (this.trail == null) {
            this.trail = new TrailRender(this.position(), 20, 20, 0.15f, DataNEssence.locate("textures/vfx/trail.png"), RenderTypeHandler::transparent).setShrink(true).startTicking();
        }
        return this.trail;
    }
}

