/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.fluid;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.block.GenderfluidGrowable;
import com.cmdpro.datanessence.fluid.ModFluidRegistryObject;
import com.cmdpro.datanessence.fluid.ModFluidType;
import com.cmdpro.datanessence.networking.ModMessages;
import com.cmdpro.datanessence.networking.packet.s2c.vfx.PlayGenderfluidTransitionEffect;
import com.cmdpro.datanessence.recipe.GenderfluidTransitionRecipe;
import com.cmdpro.datanessence.registry.MobEffectRegistry;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public class Genderfluid
extends ModFluidType {
    @Override
    public FluidType createFluidType(ModFluidRegistryObject obj) {
        return new GenderfluidType();
    }

    @Override
    public FlowingFluid createSourceFluid(ModFluidRegistryObject obj) {
        return new GenderfluidFluid.Source(obj);
    }

    @Override
    public FlowingFluid createFlowingFluid(ModFluidRegistryObject obj) {
        return new GenderfluidFluid.Flowing(obj);
    }

    @Override
    public LiquidBlock createBlock(ModFluidRegistryObject obj) {
        return new GenderfluidBlock(obj);
    }

    @Override
    public Item createBucket(ModFluidRegistryObject obj) {
        return new BucketItem((Fluid)obj.source.get(), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1));
    }

    @Override
    public boolean hasBucket() {
        return true;
    }

    public static class GenderfluidType
    extends FluidType {
        public GenderfluidType() {
            super(FluidType.Properties.create().descriptionId("block.datanessence.genderfluid").sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH));
        }

        public void setItemMovement(ItemEntity entity) {
            super.setItemMovement(entity);
            Level level = entity.level();
            if (!level.isClientSide) {
                SingleRecipeInput input = new SingleRecipeInput(entity.getItem());
                Optional recipe = level.getRecipeManager().getRecipeFor(RecipeRegistry.GENDERFLUID_TRANSITION_TYPE.get(), (RecipeInput)input, level);
                if (recipe.isPresent()) {
                    ItemStack result = ((GenderfluidTransitionRecipe)((RecipeHolder)recipe.get()).value()).assemble((RecipeInput)input, (HolderLookup.Provider)level.registryAccess());
                    ItemStack entityItem = entity.getItem();
                    DataComponentPatch resultComponents = result.getComponentsPatch();
                    DataComponentPatch entityComponents = entityItem.getComponentsPatch();
                    ItemStack finalItem = new ItemStack((ItemLike)result.getItem());
                    finalItem.setCount(result.getCount() * entityItem.getCount());
                    if (((GenderfluidTransitionRecipe)((RecipeHolder)recipe.get()).value()).getMergeComponents()) {
                        GenderfluidType.copyComponents(entityComponents, finalItem);
                    }
                    GenderfluidType.copyComponents(resultComponents, finalItem);
                    entity.setItem(finalItem);
                    entity.setDeltaMovement(entity.getDeltaMovement().x, 0.5, entity.getDeltaMovement().z);
                    ModMessages.sendToPlayersNear(new PlayGenderfluidTransitionEffect(entity.blockPosition(), entity.position()), (ServerLevel)level, entity.blockPosition().getCenter(), 128.0f);
                }
            }
        }

        private static <T> void copyComponents(DataComponentPatch from, ItemStack to) {
            for (Map.Entry i : from.entrySet()) {
                if (!((Optional)i.getValue()).isPresent()) continue;
                GenderfluidType.copyComponent((DataComponentType)i.getKey(), from, to);
            }
        }

        private static <T> void copyComponent(DataComponentType<T> type, DataComponentPatch from, ItemStack to) {
            Optional value = from.get(type);
            if (value != null && value.isPresent()) {
                to.set(type, value.get());
            }
        }
    }

    public static abstract class GenderfluidFluid {
        public static final IClientFluidTypeExtensions EXTENSIONS = new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return DataNEssence.locate("block/fluid/genderfluid_still");
            }

            public ResourceLocation getFlowingTexture() {
                return DataNEssence.locate("block/fluid/genderfluid_flowing");
            }
        };

        private static BaseFlowingFluid.Properties properties(ModFluidRegistryObject obj) {
            return new BaseFlowingFluid.Properties(obj.type, obj.source, obj.flowing).block(obj.block).bucket(obj.bucket);
        }

        public static class Source
        extends BaseFlowingFluid.Source {
            public Source(ModFluidRegistryObject obj) {
                super(GenderfluidFluid.properties(obj));
            }
        }

        public static class Flowing
        extends BaseFlowingFluid.Flowing {
            public Flowing(ModFluidRegistryObject obj) {
                super(GenderfluidFluid.properties(obj));
            }
        }
    }

    public static class GenderfluidBlock
    extends LiquidBlock {
        public GenderfluidBlock(ModFluidRegistryObject obj) {
            super((FlowingFluid)obj.source.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).mapColor(DyeColor.BLACK));
        }

        protected void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
            super.entityInside(pState, pLevel, pPos, pEntity);
            if (pEntity instanceof LivingEntity) {
                LivingEntity ent = (LivingEntity)pEntity;
                ent.addEffect(new MobEffectInstance(MobEffectRegistry.GENDER_EUPHORIA, 100));
            }
        }

        protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
            for (BlockPos queryPos : BlockPos.betweenClosed((BlockPos)pos.offset(-4, -1, -4), (BlockPos)pos.offset(4, 1, 4))) {
                BlockState queryState = world.getBlockState(queryPos);
                Block block = queryState.getBlock();
                if (!(block instanceof GenderfluidGrowable)) continue;
                GenderfluidGrowable plant = (GenderfluidGrowable)block;
                plant.grow(queryState, world, queryPos, world.getRandom(), 3);
            }
        }

        protected boolean isRandomlyTicking(BlockState pState) {
            return true;
        }
    }
}

