/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.integration.emi;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.integration.emi.recipes.EMIDryingRecipe;
import com.cmdpro.datanessence.integration.emi.recipes.EMIEntropicProcessingRecipe;
import com.cmdpro.datanessence.integration.emi.recipes.EMIFabricationRecipe;
import com.cmdpro.datanessence.integration.emi.recipes.EMIFluidMixingRecipe;
import com.cmdpro.datanessence.integration.emi.recipes.EMIInfusionRecipe;
import com.cmdpro.datanessence.integration.emi.recipes.EMIMeltingRecipe;
import com.cmdpro.datanessence.integration.emi.recipes.EMIMetalShaperRecipe;
import com.cmdpro.datanessence.integration.emi.recipes.EMIMineralPurificationRecipe;
import com.cmdpro.datanessence.integration.emi.recipes.EMISynthesisRecipe;
import com.cmdpro.datanessence.recipe.DryingRecipe;
import com.cmdpro.datanessence.recipe.EntropicProcessingRecipe;
import com.cmdpro.datanessence.recipe.FluidMixingRecipe;
import com.cmdpro.datanessence.recipe.IFabricationRecipe;
import com.cmdpro.datanessence.recipe.InfusionRecipe;
import com.cmdpro.datanessence.recipe.MeltingRecipe;
import com.cmdpro.datanessence.recipe.MetalShaperRecipe;
import com.cmdpro.datanessence.recipe.MineralPurificationRecipe;
import com.cmdpro.datanessence.recipe.SynthesisRecipe;
import com.cmdpro.datanessence.registry.BlockRegistry;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@EmiEntrypoint
public class DataNEssenceEMIPlugin
implements EmiPlugin {
    public static final ResourceLocation EMI_ICONS = ResourceLocation.fromNamespaceAndPath((String)"datanessence", (String)"textures/gui/emi_icons.png");
    public static final EmiStack FABRICATOR_WORKSTATION = EmiStack.of((ItemLike)((ItemLike)BlockRegistry.FABRICATOR.get()));
    public static final EmiStack AUTO_FABRICATOR_WORKSTATION = EmiStack.of((ItemLike)((ItemLike)BlockRegistry.AUTO_FABRICATOR.get()));
    public static final EmiStack INFUSER_WORKSTATION = EmiStack.of((ItemLike)((ItemLike)BlockRegistry.INFUSER.get()));
    public static final EmiStack ENTROPIC_PROCESSER_WORKSTATION = EmiStack.of((ItemLike)((ItemLike)BlockRegistry.ENTROPIC_PROCESSOR.get()));
    public static final EmiStack FLUID_MIXER_WORKSTATION = EmiStack.of((ItemLike)((ItemLike)BlockRegistry.FLUID_MIXER.get()));
    public static final EmiStack SYNTHESIS_CHAMBER_WORKSTATION = EmiStack.of((ItemLike)((ItemLike)BlockRegistry.SYNTHESIS_CHAMBER.get()));
    public static final EmiStack METAL_SHAPER_WORKSTATION = EmiStack.of((ItemLike)((ItemLike)BlockRegistry.METAL_SHAPER.get()));
    public static final EmiStack MELTER_WORKSTATION = EmiStack.of((ItemLike)((ItemLike)BlockRegistry.MELTER.get()));
    public static final EmiStack DRYING_TABLE_WORKSTATION = EmiStack.of((ItemLike)((ItemLike)BlockRegistry.DRYING_TABLE.get()));
    public static final EmiStack MINERAL_PURIFICATION_CHAMBER_WORKSTATION = EmiStack.of((ItemLike)((ItemLike)BlockRegistry.MINERAL_PURIFICATION_CHAMBER.get()));
    public static final EmiRecipeCategory FABRICATION = new EmiRecipeCategory(DataNEssence.locate("fabrication"), (EmiRenderable)FABRICATOR_WORKSTATION, (EmiRenderable)new EmiTexture(EMI_ICONS, 0, 0, 16, 16));
    public static final EmiRecipeCategory INFUSION = new EmiRecipeCategory(DataNEssence.locate("infusion"), (EmiRenderable)INFUSER_WORKSTATION, (EmiRenderable)new EmiTexture(EMI_ICONS, 16, 0, 16, 16));
    public static final EmiRecipeCategory ENTROPIC_PROCESSING = new EmiRecipeCategory(DataNEssence.locate("entropic_processing"), (EmiRenderable)ENTROPIC_PROCESSER_WORKSTATION, (EmiRenderable)new EmiTexture(EMI_ICONS, 32, 0, 16, 16));
    public static final EmiRecipeCategory FLUID_MIXING = new EmiRecipeCategory(DataNEssence.locate("fluid_mixing"), (EmiRenderable)FLUID_MIXER_WORKSTATION, (EmiRenderable)new EmiTexture(EMI_ICONS, 48, 0, 16, 16));
    public static final EmiRecipeCategory SYNTHESIS = new EmiRecipeCategory(DataNEssence.locate("synthesis"), (EmiRenderable)SYNTHESIS_CHAMBER_WORKSTATION, (EmiRenderable)new EmiTexture(EMI_ICONS, 64, 0, 16, 16));
    public static final EmiRecipeCategory METAL_SHAPING = new EmiRecipeCategory(DataNEssence.locate("metal_shaping"), (EmiRenderable)METAL_SHAPER_WORKSTATION, (EmiRenderable)new EmiTexture(EMI_ICONS, 80, 0, 16, 16));
    public static final EmiRecipeCategory MELTING = new EmiRecipeCategory(DataNEssence.locate("melting"), (EmiRenderable)MELTER_WORKSTATION, (EmiRenderable)new EmiTexture(EMI_ICONS, 96, 0, 16, 16));
    public static final EmiRecipeCategory DRYING = new EmiRecipeCategory(DataNEssence.locate("drying"), (EmiRenderable)DRYING_TABLE_WORKSTATION, (EmiRenderable)new EmiTexture(EMI_ICONS, 112, 0, 16, 16));
    public static final EmiRecipeCategory MINERAL_PURIFICATION = new EmiRecipeCategory(DataNEssence.locate("mineral_purification"), (EmiRenderable)MINERAL_PURIFICATION_CHAMBER_WORKSTATION, (EmiRenderable)new EmiTexture(EMI_ICONS, 128, 0, 16, 16));
    public static ItemStack ESSENCE_FURNACE = new ItemStack((ItemLike)BlockRegistry.ESSENCE_FURNACE.get().asItem());

    public void register(EmiRegistry emiRegistry) {
        emiRegistry.addCategory(FABRICATION);
        emiRegistry.addCategory(INFUSION);
        emiRegistry.addCategory(ENTROPIC_PROCESSING);
        emiRegistry.addCategory(FLUID_MIXING);
        emiRegistry.addCategory(SYNTHESIS);
        emiRegistry.addCategory(METAL_SHAPING);
        emiRegistry.addCategory(MELTING);
        emiRegistry.addCategory(DRYING);
        emiRegistry.addCategory(MINERAL_PURIFICATION);
        emiRegistry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)FABRICATOR_WORKSTATION);
        emiRegistry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)AUTO_FABRICATOR_WORKSTATION);
        emiRegistry.addWorkstation(VanillaEmiRecipeCategories.SMELTING, (EmiIngredient)EmiStack.of((ItemStack)ESSENCE_FURNACE));
        emiRegistry.addWorkstation(FABRICATION, (EmiIngredient)FABRICATOR_WORKSTATION);
        emiRegistry.addWorkstation(FABRICATION, (EmiIngredient)AUTO_FABRICATOR_WORKSTATION);
        emiRegistry.addWorkstation(INFUSION, (EmiIngredient)INFUSER_WORKSTATION);
        emiRegistry.addWorkstation(ENTROPIC_PROCESSING, (EmiIngredient)ENTROPIC_PROCESSER_WORKSTATION);
        emiRegistry.addWorkstation(FLUID_MIXING, (EmiIngredient)FLUID_MIXER_WORKSTATION);
        emiRegistry.addWorkstation(SYNTHESIS, (EmiIngredient)SYNTHESIS_CHAMBER_WORKSTATION);
        emiRegistry.addWorkstation(METAL_SHAPING, (EmiIngredient)METAL_SHAPER_WORKSTATION);
        emiRegistry.addWorkstation(MELTING, (EmiIngredient)MELTER_WORKSTATION);
        emiRegistry.addWorkstation(DRYING, (EmiIngredient)DRYING_TABLE_WORKSTATION);
        emiRegistry.addWorkstation(MINERAL_PURIFICATION, (EmiIngredient)MINERAL_PURIFICATION_CHAMBER_WORKSTATION);
        RecipeManager manager = emiRegistry.getRecipeManager();
        for (RecipeHolder recipe : manager.getAllRecipesFor(RecipeRegistry.FABRICATIONCRAFTING.get())) {
            emiRegistry.addRecipe((EmiRecipe)new EMIFabricationRecipe(recipe.id(), (IFabricationRecipe)recipe.value()));
        }
        for (RecipeHolder recipe : manager.getAllRecipesFor(RecipeRegistry.INFUSION_TYPE.get())) {
            emiRegistry.addRecipe((EmiRecipe)new EMIInfusionRecipe(recipe.id(), (InfusionRecipe)recipe.value()));
        }
        for (RecipeHolder recipe : manager.getAllRecipesFor(RecipeRegistry.ENTROPIC_PROCESSING_TYPE.get())) {
            emiRegistry.addRecipe((EmiRecipe)new EMIEntropicProcessingRecipe(recipe.id(), (EntropicProcessingRecipe)recipe.value()));
        }
        for (RecipeHolder recipe : manager.getAllRecipesFor(RecipeRegistry.FLUID_MIXING_TYPE.get())) {
            emiRegistry.addRecipe((EmiRecipe)new EMIFluidMixingRecipe(recipe.id(), (FluidMixingRecipe)recipe.value()));
        }
        for (RecipeHolder recipe : manager.getAllRecipesFor(RecipeRegistry.SYNTHESIS_TYPE.get())) {
            emiRegistry.addRecipe((EmiRecipe)new EMISynthesisRecipe(recipe.id(), (SynthesisRecipe)recipe.value()));
        }
        for (RecipeHolder recipe : manager.getAllRecipesFor(RecipeRegistry.METAL_SHAPING_TYPE.get())) {
            emiRegistry.addRecipe((EmiRecipe)new EMIMetalShaperRecipe(recipe.id(), (MetalShaperRecipe)recipe.value()));
        }
        for (RecipeHolder recipe : manager.getAllRecipesFor(RecipeRegistry.MELTING_TYPE.get())) {
            emiRegistry.addRecipe((EmiRecipe)new EMIMeltingRecipe(recipe.id(), (MeltingRecipe)recipe.value()));
        }
        for (RecipeHolder recipe : manager.getAllRecipesFor(RecipeRegistry.DRYING_TYPE.get())) {
            emiRegistry.addRecipe((EmiRecipe)new EMIDryingRecipe(recipe.id(), (DryingRecipe)recipe.value()));
        }
        for (RecipeHolder recipe : manager.getAllRecipesFor(RecipeRegistry.MINERAL_PURIFICATION_TYPE.get())) {
            emiRegistry.addRecipe((EmiRecipe)new EMIMineralPurificationRecipe(recipe.id(), (MineralPurificationRecipe)recipe.value()));
        }
    }
}

