/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.integration.emi.recipes;

import com.cmdpro.datanessence.integration.emi.DataNEssenceEMIPlugin;
import com.cmdpro.datanessence.recipe.DryingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class EMIDryingRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final EmiStack input;
    private final EmiIngredient additive;
    private final List<EmiStack> output;
    private final int time;

    public EMIDryingRecipe(ResourceLocation id, DryingRecipe recipe) {
        this.id = id;
        this.input = EmiStack.of((Fluid)recipe.getInput().getFluid(), (long)recipe.getInput().getAmount());
        this.additive = recipe.getIngredients().isEmpty() ? null : EmiIngredient.of((Ingredient)((Ingredient)recipe.getIngredients().get(0)));
        this.output = List.of(EmiStack.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())));
        this.time = recipe.getTime();
    }

    public EmiRecipeCategory getCategory() {
        return DataNEssenceEMIPlugin.DRYING;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        ArrayList<EmiIngredient> ret = new ArrayList<EmiIngredient>();
        ret.add((EmiIngredient)this.input);
        if (this.additive != null) {
            ret.add(this.additive);
        }
        return ret;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 123;
    }

    public int getDisplayHeight() {
        return 60;
    }

    public void addWidgets(WidgetHolder widgets) {
        ResourceLocation background = ResourceLocation.fromNamespaceAndPath((String)"datanessence", (String)"textures/gui/data_tablet_crafting2.png");
        widgets.addTexture(background, 0, 0, this.getDisplayWidth(), this.getDisplayHeight(), 133, 196);
        widgets.addSlot((EmiIngredient)this.input, 29, 9).drawBack(false);
        if (this.additive != null) {
            widgets.addSlot(this.additive, 29, 31).drawBack(false);
        }
        widgets.addSlot((EmiIngredient)this.output.get(0), 73, 21).recipeContext((EmiRecipe)this).drawBack(false);
        widgets.addText((Component)Component.translatable((String)"emi.datanessence.time_seconds", (Object[])new Object[]{(double)this.time / 20.0}), 82, 44, 0xFFFFFF, false).horizontalAlign(TextWidget.Alignment.CENTER);
    }
}

