/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.integration.emi.recipes;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.essence.EssenceBarBackgroundTypes;
import com.cmdpro.datanessence.integration.emi.DataNEssenceEMIPlugin;
import com.cmdpro.datanessence.integration.emi.DataNEssenceEMIRecipe;
import com.cmdpro.datanessence.integration.emi.widgets.EssenceBarWidget;
import com.cmdpro.datanessence.recipe.FluidMixingRecipe;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;

public class EMIFluidMixingRecipe
extends DataNEssenceEMIRecipe {
    private final EmiIngredient item;
    private final EmiStack fluid1;
    private final EmiStack fluid2;
    private final float essenceCost;
    private final int time;

    public EMIFluidMixingRecipe(ResourceLocation id, FluidMixingRecipe recipe) {
        super(DataNEssenceEMIPlugin.FLUID_MIXING, id, recipe.getEntry(), 123, 60);
        this.fluid1 = EmiStack.of((Fluid)recipe.getInput1().getFluid(), (long)recipe.getInput1().getAmount());
        this.fluid2 = recipe.getInput2() == null ? null : EmiStack.of((Fluid)recipe.getInput2().getFluid(), (long)recipe.getInput2().getAmount());
        this.item = recipe.getIngredients().isEmpty() ? null : EmiIngredient.of((Ingredient)((Ingredient)recipe.getIngredients().get(0)));
        this.inputs = new ArrayList<EmiIngredient>(){
            {
                this.add(EMIFluidMixingRecipe.this.fluid1);
                if (EMIFluidMixingRecipe.this.fluid2 != null) {
                    this.add(EMIFluidMixingRecipe.this.fluid2);
                }
                if (EMIFluidMixingRecipe.this.item != null) {
                    this.add(EMIFluidMixingRecipe.this.item);
                }
            }
        };
        this.outputs = List.of(EmiStack.of((Fluid)recipe.getOutput().getFluid(), (long)recipe.getOutput().getAmount()));
        this.essenceCost = recipe.getEssenceCost();
        this.time = recipe.getTime();
    }

    public int getDisplayWidth() {
        return 123;
    }

    public int getDisplayHeight() {
        return 60;
    }

    @Override
    public void addUnlockedWidgets(WidgetHolder widgetHolder) {
        ResourceLocation background = DataNEssence.locate("textures/gui/data_tablet_crafting.png");
        widgetHolder.addTexture(background, 0, 0, this.getDisplayWidth(), this.getDisplayHeight(), 10, 76);
        widgetHolder.addSlot((EmiIngredient)this.fluid1, 13, 10).drawBack(false);
        if (this.fluid2 != null) {
            widgetHolder.addSlot((EmiIngredient)this.fluid2, 13, 32).drawBack(false);
        }
        if (this.item != null) {
            widgetHolder.addSlot(this.item, 34, 21).drawBack(false);
        }
        widgetHolder.addSlot((EmiIngredient)this.outputs.get(0), 77, 21).recipeContext((EmiRecipe)this).drawBack(false);
        widgetHolder.addText((Component)Component.translatable((String)"emi.datanessence.time_seconds", (Object[])new Object[]{(double)this.time / 20.0}), 86, 44, 0xFFFFFF, false).horizontalAlign(TextWidget.Alignment.CENTER);
        widgetHolder.add((Widget)new EssenceBarWidget(5, 19, EssenceTypeRegistry.ESSENCE.get(), this.essenceCost, 1000.0f, EssenceBarBackgroundTypes.INDUSTRIAL));
    }
}

